/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FogParticle
extends WeatherParticle {
    private static final float FADE_DURATION = 40.0f;
    private float targetAlpha = 1.0f;
    private float baseQuadSize;

    private FogParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        this.m_108337_(provider.m_213979_(level.m_213780_()));
        this.f_107225_ = ParticleRainClient.config.particleRadius * 5;
        double distance = Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(new Vec3(x, y, z));
        this.f_107663_ = (float)((double)ParticleRainClient.config.fog.size / distance);
        this.baseQuadSize = (float)((double)ParticleRainClient.config.fog.size / distance);
        Color color = new Color(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47539_()).darker();
        this.f_107227_ = (float)color.getRed() / 255.0f;
        this.f_107228_ = (float)color.getGreen() / 255.0f;
        this.f_107229_ = (float)color.getBlue() / 255.0f;
        this.f_107204_ = this.f_107231_ = level.f_46441_.m_188501_() * (float)Math.PI;
        this.f_107215_ = this.f_107226_ / 3.0f;
        this.f_107217_ = this.f_107226_ / 3.0f;
        this.f_107226_ = ParticleRainClient.config.fog.gravity;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        double camdist = Minecraft.m_91087_().f_91075_.m_20182_().m_82554_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_));
        this.f_107663_ = (float)camdist / 2.0f;
        BlockState fallingTowards = this.f_107208_.m_8055_(this.pos.m_7918_(3, -1, 3));
        BlockPos blockPos = this.pos.m_7918_(2, -4, 2);
        if (!(this.f_107208_.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockPos.m_123341_(), blockPos.m_123343_()) < blockPos.m_123342_() && fallingTowards.m_60819_().m_76178_() || this.shouldFadeOut)) {
            this.shouldFadeOut = true;
        }
        if (this.f_107218_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Vector3f localPos = new Vector3f(x, y, z);
        Quaternionf quaternion = Axis.f_252436_.m_252961_((float)Math.atan2(x, z) + (float)Math.PI);
        float yAngle = (float)Math.asin(y / localPos.length());
        quaternion.rotateX(yAngle);
        quaternion.rotateZ((float)Math.atan2(x, z));
        if (yAngle < -1.0f) {
            this.shouldFadeOut = true;
        }
        quaternion.rotateZ(Mth.m_14179_((float)f, (float)this.f_107204_, (float)this.f_107231_));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, f);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @Override
    public void fadeIn() {
        if ((float)this.f_107224_ < 40.0f) {
            float progress = (float)this.f_107224_ / 40.0f;
            this.f_107230_ = Mth.m_14179_((float)progress, (float)0.0f, (float)this.targetAlpha);
            this.f_107663_ = Mth.m_14179_((float)progress, (float)0.0f, (float)this.baseQuadSize);
        }
    }

    @Override
    public void fadeOut() {
        float progress = Math.min(((float)this.f_107224_ - ((float)this.f_107225_ - 40.0f)) / 40.0f, 1.0f);
        if (progress > 0.0f) {
            this.f_107230_ = Mth.m_14179_((float)progress, (float)this.targetAlpha, (float)0.0f);
            this.f_107663_ = Mth.m_14179_((float)progress, (float)this.baseQuadSize, (float)0.0f);
            if (progress >= 1.0f) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new FogParticle(level, x, y, z, this.provider);
        }
    }
}

