/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals.injector;

import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.goals.ReactToSoundGoal;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ezvcsurvival")
public class ReactToSoundGoalInjector {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        List<SoundGroupData> gunfireGroups;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        ResourceLocation mobIdRL = BuiltInRegistries.f_256780_.m_7981_((Object)mob.m_6095_());
        String mobId = mobIdRL.toString();
        Map<String, Object> soundConfig = SoundConfig.getMobSoundReaction(mobId);
        if (soundConfig != null) {
            List<SoundGroupData> soundGroups;
            double speed = soundConfig.get("speed") instanceof Number ? ((Number)soundConfig.get("speed")).doubleValue() : 1.0;
            double rangeDouble = soundConfig.get("range") instanceof Number ? ((Number)soundConfig.get("range")).doubleValue() : 16.0;
            int range = (int)rangeDouble;
            List groups = (List)soundConfig.get("groups");
            if (groups != null && !groups.isEmpty() && !(soundGroups = SoundConfig.getSoundGroupsForMob(mobId)).isEmpty()) {
                mob.f_21345_.m_25352_(2, (Goal)new ReactToSoundGoal(mob, speed, range, soundGroups));
            }
        }
        if (!(gunfireGroups = SoundConfig.getSoundGroupsForGunFireMob(mobId)).isEmpty()) {
            double speed = 1.0;
            int range = 20;
            if (soundConfig != null) {
                if (soundConfig.containsKey("speed")) {
                    speed = ((Number)soundConfig.get("speed")).doubleValue();
                }
                if (soundConfig.containsKey("range")) {
                    range = ((Number)soundConfig.get("range")).intValue();
                }
            }
            mob.f_21345_.m_25352_(2, (Goal)new ReactToSoundGoal(mob, speed, range, gunfireGroups));
        }
    }
}

