/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.commands.SoundEffectCommand;
import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.GunshotData;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GunFireListener {
    private static final List<GunshotData> gunshotPositions = new CopyOnWriteArrayList<GunshotData>();
    private static final long EXPIRATION_TIME_MS = 5000L;

    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        ItemStack gunStack = event.getGunItemStack();
        IGun gun = IGun.getIGunOrNull((ItemStack)gunStack);
        LivingEntity shooter = event.getShooter();
        if (shooter != null && GunFireListener.useSilenceSound(shooter, gunStack)) {
            return;
        }
        if (shooter == null) {
            return;
        }
        Vec3 shooterPos = shooter.m_20182_();
        GunTabType gunType = GunTabType.PISTOL;
        if (gun != null) {
            try {
                ResourceLocation gunId = gun.getGunId(gunStack);
                CommonGunIndex commonGunIndex = CommonGunIndexRegistry.getCommonGunIndex(gunId);
                if (commonGunIndex != null) {
                    String typeStr = commonGunIndex.getType();
                    gunType = GunTabType.valueOf((String)typeStr.toUpperCase());
                } else {
                    String gunIdStr = gunId.toString().toLowerCase();
                    gunType = gunIdStr.contains("sniper") ? GunTabType.SNIPER : (gunIdStr.contains("rifle") ? GunTabType.RIFLE : (gunIdStr.contains("shotgun") ? GunTabType.SHOTGUN : (gunIdStr.contains("smg") ? GunTabType.SMG : (gunIdStr.contains("rpg") ? GunTabType.RPG : (gunIdStr.contains("mg") ? GunTabType.MG : GunTabType.PISTOL)))));
                }
            }
            catch (Exception e) {
                gunType = GunTabType.PISTOL;
            }
        }
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundEffectCommand.applyEffect(serverPlayer);
        }
        gunshotPositions.add(new GunshotData(shooterPos, System.currentTimeMillis(), gunType));
    }

    private static boolean useSilenceSound(LivingEntity entity, ItemStack gunStack) {
        ResourceLocation gunId;
        Pair silence;
        AttachmentCacheProperty cacheProperty;
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)entity);
        if (operator != null && (cacheProperty = operator.getCacheProperty()) != null && (silence = (Pair)cacheProperty.getCache(SilenceModifier.ID)) != null && ((Boolean)silence.right()).booleanValue()) {
            return true;
        }
        IGun gun = IGun.getIGunOrNull((ItemStack)gunStack);
        return gun != null && SoundConfig.isSilencedGun(gunId = gun.getGunId(gunStack));
    }

    public static GunshotData getLastGunshotData() {
        long currentTime = System.currentTimeMillis();
        gunshotPositions.removeIf(record -> currentTime - record.timestamp > 5000L);
        return gunshotPositions.isEmpty() ? null : gunshotPositions.get(gunshotPositions.size() - 1);
    }

    public static class CommonGunIndexRegistry {
        private static final Map<ResourceLocation, CommonGunIndex> registry = new HashMap<ResourceLocation, CommonGunIndex>();

        public static CommonGunIndex getCommonGunIndex(ResourceLocation id) {
            return registry.get(id);
        }

        public static void registerCommonGunIndex(ResourceLocation id, CommonGunIndex index) {
            registry.put(id, index);
        }
    }
}

