/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival;

import com.armilp.ezvcsurvival.api.IAudioModifier;
import com.armilp.ezvcsurvival.commands.SoundEffectCommand;
import com.armilp.ezvcsurvival.compat.audio.AudioModifierFactory;
import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.SoundData;
import com.armilp.ezvcsurvival.events.ArmorEventHandler;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@ForgeVoicechatPlugin
@Mod.EventBusSubscriber(modid="ezvcsurvival")
public class Plugin
implements VoicechatPlugin {
    private static final boolean DEBUG = false;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<UUID, SoundData> playerSoundLocations = new ConcurrentHashMap<UUID, SoundData>();
    private static final Map<UUID, Long> lastVoiceEffectTime = new ConcurrentHashMap<UUID, Long>();
    private static final long DEATH_ANGELS_EFFECT_COOLDOWN_MS = 3000L;
    private static VoicechatApi voicechatApi;
    @Nullable
    private OpusDecoder decoder;

    public String getPluginId() {
        return "ezvcsurvival";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
    }

    public static double calculateAudioLevel(short[] samples) {
        double rms = 0.0;
        for (short sample : samples) {
            double normalizedSample = (double)sample / 32767.0;
            rms += normalizedSample * normalizedSample;
        }
        int sampleCount = samples.length;
        double d = rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        if (rms > 0.0) {
            return Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0);
        }
        return -127.0;
    }

    public static BlockPos getLastSoundLocation(BlockPos zombiePosition, double range) {
        return playerSoundLocations.values().stream().filter(data -> zombiePosition.m_123331_((Vec3i)data.getPosition()) <= data.getRange() * data.getRange()).min(Comparator.comparingDouble(data -> zombiePosition.m_123331_((Vec3i)data.getPosition()))).map(SoundData::getPosition).orElse(null);
    }

    public static double getLastSoundSpeed(BlockPos zombiePosition, double range) {
        return playerSoundLocations.values().stream().filter(data -> zombiePosition.m_123331_((Vec3i)data.getPosition()) <= data.getRange() * data.getRange()).min(Comparator.comparingDouble(data -> zombiePosition.m_123331_((Vec3i)data.getPosition()))).map(SoundData::getSpeed).orElse(1.0);
    }

    public void onMicrophonePacket(MicrophonePacketEvent event) {
        Object object;
        short[] decoded;
        ServerPlayer player;
        VoicechatConnection sender = event.getSenderConnection();
        if (sender == null || sender.getPlayer() == null) {
            return;
        }
        Object object2 = sender.getPlayer().getPlayer();
        if (object2 instanceof ServerPlayer && ((player = (ServerPlayer)object2).m_7500_() || player.m_5833_())) {
            return;
        }
        if (this.decoder == null || this.decoder.isClosed()) {
            this.decoder = voicechatApi.createDecoder();
        }
        this.decoder.resetState();
        byte[] opusEncodedData = ((MicrophonePacket)event.getPacket()).getOpusEncodedData();
        try {
            decoded = this.decoder.decode(opusEncodedData);
        }
        catch (Exception e) {
            return;
        }
        double audioLevel = Plugin.calculateAudioLevel(decoded);
        UUID playerUUID = sender.getPlayer().getUuid();
        Position voicechatPosition = sender.getPlayer().getPosition();
        Vec3 senderVec = new Vec3(voicechatPosition.getX(), voicechatPosition.getY(), voicechatPosition.getZ());
        BlockPos playerPosition = new BlockPos((int)Math.floor(senderVec.f_82479_), (int)Math.floor(senderVec.f_82480_), (int)Math.floor(senderVec.f_82481_));
        double perceivedIntensity = audioLevel - 20.0 * Math.log10(senderVec.m_82554_(new Vec3((double)playerPosition.m_123341_(), (double)playerPosition.m_123342_(), (double)playerPosition.m_123343_())) + 1.0);
        long currentTime = System.currentTimeMillis();
        if (perceivedIntensity >= (Double)VoiceConfig.DEATH_ANGELS_THRESHOLD.get() && (!lastVoiceEffectTime.containsKey(playerUUID) || currentTime - lastVoiceEffectTime.get(playerUUID) > 3000L) && (object = sender.getPlayer().getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)object;
            SoundEffectCommand.applyEffect(serverPlayer);
            lastVoiceEffectTime.put(playerUUID, currentTime);
        }
        boolean isWhispering = ((MicrophonePacket)event.getPacket()).isWhispering();
        double whisperRangeMultiplier = (Double)VoiceConfig.WHISPER_RANGE_MULTIPLIER.get();
        double whisperSpeedMultiplier = (Double)VoiceConfig.WHISPER_SPEED_MULTIPLIER.get();
        double thunderRangeMultiplier = (Double)VoiceConfig.THUNDER_RANGE_MULTIPLIER.get();
        double sneakingRangeMultiplier = (Double)VoiceConfig.SNEAKING_RANGE_MULTIPLIER.get();
        List<String> mobIds = this.getConfiguredMobIds();
        List<String> animalIds = this.getConfiguredAnimalIds();
        ArrayList<String> allIds = new ArrayList<String>();
        allIds.addAll(animalIds);
        allIds.addAll(mobIds);
        for (String id : allIds) {
            double distanceToListener;
            Object object3;
            double threshold = this.getActivationThreshold(id);
            double detectionRange = this.getDetectionRange(id);
            double speed = Plugin.getSpeed(id);
            if (isWhispering) {
                detectionRange *= whisperRangeMultiplier;
                speed *= whisperSpeedMultiplier;
            }
            if ((object3 = sender.getPlayer().getPlayer()) instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)object3;
                if (p.m_6047_()) {
                    detectionRange *= sneakingRangeMultiplier;
                }
                if (p.m_9236_().m_46471_() || p.m_9236_().m_46470_()) {
                    detectionRange *= thunderRangeMultiplier;
                }
                double[] armorMult = ArmorEventHandler.getArmorMultipliers((Player)p);
                detectionRange *= armorMult[1];
                speed *= armorMult[0];
            }
            IAudioModifier audioModifier = AudioModifierFactory.createAudioModifier(0.5, "voicechat", senderVec, senderVec);
            detectionRange = audioModifier.computeModifiedRange(detectionRange);
            double perceivedIntensityFinal = perceivedIntensity;
            if (perceivedIntensityFinal < threshold || !((distanceToListener = 0.0) <= detectionRange)) continue;
            BlockPos precisePos = new BlockPos((int)Math.floor(senderVec.f_82479_), (int)Math.floor(senderVec.f_82480_), (int)Math.floor(senderVec.f_82481_));
            playerSoundLocations.put(playerUUID, new SoundData(precisePos, detectionRange, speed));
        }
        scheduler.schedule(() -> playerSoundLocations.remove(playerUUID), 5L, TimeUnit.SECONDS);
    }

    private List<String> getConfiguredMobIds() {
        Map<String, Map<String, Double>> mobConfigs = VoiceConfig.getMobVoiceConfigs();
        return new ArrayList<String>(mobConfigs.keySet());
    }

    private List<String> getConfiguredAnimalIds() {
        Map<String, Map<String, Double>> mobConfigs = VoiceConfig.getAnimalVoiceConfigs();
        return new ArrayList<String>(mobConfigs.keySet());
    }

    private double getActivationThreshold(String mobId) {
        Map<String, Double> mobConfig = VoiceConfig.getMobVoiceConfigs().get(mobId);
        if (mobConfig != null && mobConfig.containsKey("threshold")) {
            return mobConfig.get("threshold");
        }
        return -40.0;
    }

    private double getDetectionRange(String mobId) {
        Map<String, Double> mobConfig = VoiceConfig.getMobVoiceConfigs().get(mobId);
        if (mobConfig != null && mobConfig.containsKey("range")) {
            return mobConfig.get("range");
        }
        return 16.0;
    }

    public static double getSpeed(String mobId) {
        Map<String, Double> mobConfig = VoiceConfig.getMobVoiceConfigs().get(mobId);
        if (mobConfig != null && mobConfig.containsKey("speed")) {
            return mobConfig.get("speed");
        }
        return 1.0;
    }
}

