/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureDimension;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureDimensionListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureDimensionsPacket {
    private final Map<ResourceLocation, JsonTemperatureDimension> temperatureDimensions;
    private final int size;

    public SyncTemperatureDimensionsPacket(Map<ResourceLocation, JsonTemperatureDimension> temperatureDimensions) {
        this.temperatureDimensions = Map.copyOf(temperatureDimensions);
        this.size = temperatureDimensions.size();
    }

    public static void encode(SyncTemperatureDimensionsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonTemperatureDimension> e : message.temperatureDimensions.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonTemperatureDimension.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncTemperatureDimensionsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonTemperatureDimension> temperatureDimensions = new HashMap<ResourceLocation, JsonTemperatureDimension>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonTemperatureDimension.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> temperatureDimensions.put(key, (JsonTemperatureDimension)t));
        }
        return new SyncTemperatureDimensionsPacket(temperatureDimensions);
    }

    public static void handle(SyncTemperatureDimensionsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureDimensionsPacket.syncTemperatureDimensions(message.temperatureDimensions)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureDimensions(final Map<ResourceLocation, JsonTemperatureDimension> temperatureDimensions) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureDimensionListener.acceptServerTemperatureDimensions(temperatureDimensions);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonTemperatureDimension> temperatureDimensions) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureDimensionsPacket(temperatureDimensions));
    }
}

