/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumableBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureConsumableBlockManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureConsumableBlocksPacket;

public class TemperatureConsumableBlockListener
extends SimpleJsonResourceReloadListener
implements ITemperatureConsumableBlockManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> TEMPERATURE_CONSUMABLE_BLOCKS = new HashMap<ResourceLocation, List<JsonTemperatureConsumableBlock>>();

    public TemperatureConsumableBlockListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/consumable_blocks");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_CONSUMABLE_BLOCKS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureConsumableBlock.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                List temperatures = (List)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature consumable block : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_CONSUMABLE_BLOCKS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature consumable block json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature consumable blocks", (Object)TEMPERATURE_CONSUMABLE_BLOCKS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureConsumableBlocksPacket.sendTo(packetTarget, TEMPERATURE_CONSUMABLE_BLOCKS);
    }

    public static void acceptServerTemperatureConsumableBlocks(Map<ResourceLocation, List<JsonTemperatureConsumableBlock>> temperatureConsumableBlocks) {
        TEMPERATURE_CONSUMABLE_BLOCKS.clear();
        TEMPERATURE_CONSUMABLE_BLOCKS.putAll(temperatureConsumableBlocks);
    }

    @Override
    public List<JsonTemperatureConsumableBlock> get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_CONSUMABLE_BLOCKS.get(itemRegistryName);
    }
}

