/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.origins;

import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.temperature.DynamicModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;

public class OriginsDynamicModifier
extends DynamicModifierBase {
    @Override
    public float applyDynamicPlayerInfluence(Player player, float currentTemperature, float currentResistance) {
        if (!LegendarySurvivalOverhaul.originsLoaded) {
            return 0.0f;
        }
        float effectiveResistance = 0.0f;
        float diffToAverage = currentTemperature - TemperatureEnum.NORMAL.getMiddle();
        LazyOptional optionalOrigin = player.getCapability(OriginsAPI.ORIGIN_CONTAINER);
        if (optionalOrigin.isPresent() && optionalOrigin.resolve().isPresent()) {
            IOriginContainer origins = (IOriginContainer)optionalOrigin.resolve().get();
            for (ResourceKey origin : origins.getOrigins().values()) {
                JsonTemperatureResistance config = TemperatureDataManager.getOrigin(origin.m_135782_());
                if (config == null) continue;
                double maxResistance = config.thermalResistance;
                if (diffToAverage > 0.0f) {
                    effectiveResistance = (float)Mth.m_14008_((double)(maxResistance += (double)config.heatResistance), (double)currentResistance, (double)(diffToAverage + currentResistance));
                    effectiveResistance = -effectiveResistance;
                    continue;
                }
                if (!(diffToAverage < 0.0f)) continue;
                diffToAverage = -diffToAverage;
                currentResistance = -currentResistance;
                effectiveResistance = (float)Mth.m_14008_((double)(maxResistance += (double)config.coldResistance), (double)currentResistance, (double)(diffToAverage + currentResistance));
            }
        }
        return effectiveResistance;
    }
}

