/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.config.json_old.thirst;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.JsonPropertyValue;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.thirst.JsonEffectParameter;

public class JsonConsumableThirst {
    @SerializedName(value="hydration")
    public int hydration;
    @SerializedName(value="saturation")
    public float saturation;
    @SerializedName(value="effects")
    public List<JsonEffectParameter> effects;
    @SerializedName(value="nbt")
    public Map<String, String> nbt;

    public JsonConsumableThirst(int hydration, float saturation, JsonEffectParameter[] effects, JsonPropertyValue ... nbt) {
        this.hydration = hydration;
        this.saturation = saturation;
        this.effects = new ArrayList<JsonEffectParameter>();
        this.effects.addAll(Arrays.asList(effects));
        this.nbt = new HashMap<String, String>();
        for (JsonPropertyValue prop : nbt) {
            this.nbt.put(prop.name, prop.value);
        }
    }

    public JsonPropertyValue[] getNbtArray() {
        ArrayList<JsonPropertyValue> jpvList = new ArrayList<JsonPropertyValue>();
        for (Map.Entry<String, String> entry : this.nbt.entrySet()) {
            jpvList.add(new JsonPropertyValue(entry.getKey(), entry.getValue()));
        }
        return jpvList.toArray(new JsonPropertyValue[0]);
    }

    public boolean matchesNbt(ItemStack itemStack) {
        if (itemStack.m_41782_() == this.nbt.isEmpty()) {
            return false;
        }
        CompoundTag itemStackTag = itemStack.m_41783_();
        if (itemStackTag == null && this.nbt.isEmpty()) {
            return true;
        }
        assert (itemStackTag != null);
        for (Map.Entry<String, String> nbtEntry : this.nbt.entrySet()) {
            if (!itemStackTag.m_128441_(nbtEntry.getKey())) {
                return false;
            }
            byte tagType = itemStackTag.m_128435_(nbtEntry.getKey());
            if (tagType == 8) {
                if (itemStackTag.m_128461_(nbtEntry.getKey()).equals(nbtEntry.getValue())) continue;
                return false;
            }
            if (tagType == 1 || tagType == 2 || tagType == 3 || tagType == 4 || tagType == 5 || tagType == 6) {
                if (itemStackTag.m_128459_(nbtEntry.getKey()) == Double.parseDouble(nbtEntry.getValue())) continue;
                return false;
            }
            LegendarySurvivalOverhaul.LOGGER.error("Error while matching nbt for {} : Tag type {} not taken into account.\nIt can either be a String (tag type 8) or a numeric (tag type in [1-6])", (Object)itemStack.m_41778_(), (Object)tagType);
        }
        return true;
    }

    public boolean isDefault() {
        return this.nbt.isEmpty();
    }

    public boolean matchesNbt(JsonPropertyValue ... nbt) {
        if (nbt.length != this.nbt.keySet().size()) {
            return false;
        }
        for (JsonPropertyValue prop : nbt) {
            if (!this.nbt.containsKey(prop.name)) {
                return false;
            }
            if (prop.value.equals(this.nbt.get(prop.name))) continue;
            return false;
        }
        return true;
    }
}

