/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class FakePlayerGetter {
    private final GenericTileEntity te;
    private final String fakeName;
    private ServerPlayer harvester = null;

    public FakePlayerGetter(GenericTileEntity te, String fakeName) {
        this.te = te;
        this.fakeName = fakeName;
    }

    public ServerPlayer get() {
        ServerPlayer player;
        ServerPlayer playerEntity = this.getFakeHarvester();
        UUID owner = this.te.getOwnerUUID();
        if (owner != null && (player = this.te.m_58904_().m_7654_().m_6846_().m_11259_(owner)) != null && !Objects.equals(playerEntity.m_36316_().getName(), player.m_36316_().getName())) {
            this.harvester = null;
            playerEntity = this.getFakeHarvester();
        }
        return playerEntity;
    }

    private ServerPlayer getFakeHarvester() {
        if (this.harvester == null) {
            UUID owner = this.te.getOwnerUUID();
            if (owner == null) {
                owner = UUID.nameUUIDFromBytes("rftools_builder".getBytes());
            }
            ServerLevel serverLevel = (ServerLevel)this.te.m_58904_();
            this.harvester = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(owner, this.getName()));
            BlockPos worldPosition = this.te.m_58899_();
            this.harvester.m_6034_((double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_());
        }
        return this.harvester;
    }

    private String getName() {
        UUID owner = this.te.getOwnerUUID();
        if (owner == null) {
            return this.fakeName;
        }
        ServerPlayer player = this.te.m_58904_().m_7654_().m_6846_().m_11259_(owner);
        if (player == null) {
            return this.fakeName;
        }
        return player.m_36316_().getName();
    }
}

