/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketServerCommandTyped(BlockPos pos, ResourceKey<Level> dimensionId, String command, TypedMap params) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "servercommandtyped");

    public static PacketServerCommandTyped create(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceKey<Level> dimensionId = buf.readBoolean() ? LevelTools.getId(buf.m_130281_()) : null;
        String command = buf.m_130136_(Short.MAX_VALUE);
        TypedMap params = TypedMapTools.readArguments(buf);
        return new PacketServerCommandTyped(pos, dimensionId, command, params);
    }

    public static PacketServerCommandTyped create(BlockPos blockPos, ResourceKey<Level> dimension, String command, TypedMap params) {
        return new PacketServerCommandTyped(blockPos, dimension, command, params);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.m_130085_(this.dimensionId.m_135782_());
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(playerEntity -> {
            Object world = this.dimensionId == null ? playerEntity.m_20193_() : LevelTools.getLevel(playerEntity.m_9236_(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (world.m_46805_(this.pos)) {
                GenericTileEntity generic;
                BlockEntity patt2687$temp = world.m_7702_(this.pos);
                if (patt2687$temp instanceof GenericTileEntity && (generic = (GenericTileEntity)patt2687$temp).executeServerCommand(this.command, (Player)playerEntity, this.params)) {
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        }));
    }
}

