/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.SendPreferencesToClientHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketSendPreferencesToClient(BuffStyle buffStyle, Integer buffX, Integer buffY, GuiStyle style) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "sendpreferences");

    public static PacketSendPreferencesToClient create(ByteBuf buf) {
        BuffStyle buffStyle = BuffStyle.values()[buf.readInt()];
        int buffX = buf.readInt();
        int buffY = buf.readInt();
        GuiStyle style = GuiStyle.values()[buf.readInt()];
        return new PacketSendPreferencesToClient(buffStyle, buffX, buffY, style);
    }

    public static PacketSendPreferencesToClient create(BuffStyle buffStyle, int buffX, int buffY, GuiStyle style) {
        return new PacketSendPreferencesToClient(buffStyle, buffX, buffY, style);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.buffStyle.ordinal());
        buf.writeInt(this.buffX.intValue());
        buf.writeInt(this.buffY.intValue());
        buf.writeInt(this.style.ordinal());
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public BuffStyle getBuffStyle() {
        return this.buffStyle;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public GuiStyle getStyle() {
        return this.style;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> SendPreferencesToClientHelper.setPreferences(this));
    }
}

