/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TrashCanBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final IItemHandler ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.m_41619_() || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist ? ItemStack.f_41583_ : stack;
            }
            return TrashCanBlockEntity.this.itemFilterWhitelist ? stack : ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            for (ItemStack filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.m_41619_() || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.itemFilterWhitelist;
        }
    };
    public final IFluidHandler FLUID_HANDLER = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.liquidFilterWhitelist;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(resource)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist ? resource.getAmount() : 0;
            }
            return TrashCanBlockEntity.this.liquidFilterWhitelist ? 0 : resource.getAmount();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public final IItemHandler LIQUID_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanBlockEntity.this.liquidItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanBlockEntity.this.liquidItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanBlockEntity.this.liquidItem.m_41619_() || stack.m_41619_()) {
                return stack;
            }
            if (!simulate) {
                TrashCanBlockEntity.this.liquidItem = stack.m_41777_();
                TrashCanBlockEntity.this.liquidItem.m_41764_(1);
                TrashCanBlockEntity.this.dataChanged();
            }
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41774_(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanBlockEntity.this.liquidItem.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = TrashCanBlockEntity.this.liquidItem.m_41777_();
            stack.m_41764_(Math.min(amount, stack.m_41613_()));
            if (!simulate) {
                TrashCanBlockEntity.this.liquidItem.m_41774_(amount);
                TrashCanBlockEntity.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            boolean filtered = !TrashCanBlockEntity.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanBlockEntity.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).filter(handler -> {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (handler.getFluidInTank(tank).isEmpty()) continue;
                    return true;
                }
                return false;
            }).isPresent() || Compatibility.MEKANISM.doesItemHaveGasStored(stack);
        }
    };
    public final IEnergyStorage ENERGY_STORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TrashCanBlockEntity.this.useEnergyLimit ? Math.min(maxReceive, TrashCanBlockEntity.this.energyLimit) : maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    public final IItemHandler ENERGY_ITEM_HANDLER = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TrashCanBlockEntity.this.energyItem = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TrashCanBlockEntity.this.energyItem;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || !TrashCanBlockEntity.this.energyItem.m_41619_() || stack.m_41619_()) {
                return stack;
            }
            if (!simulate) {
                TrashCanBlockEntity.this.energyItem = stack.m_41777_();
                TrashCanBlockEntity.this.energyItem.m_41764_(1);
                TrashCanBlockEntity.this.dataChanged();
            }
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41774_(1);
            return stack1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0 || TrashCanBlockEntity.this.energyItem.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = TrashCanBlockEntity.this.energyItem.m_41777_();
            stack.m_41764_(Math.min(amount, stack.m_41613_()));
            if (!simulate) {
                TrashCanBlockEntity.this.energyItem.m_41774_(amount);
                TrashCanBlockEntity.this.dataChanged();
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getCapability(ForgeCapabilities.ENERGY).filter(storage -> storage.canExtract() && storage.getEnergyStored() > 0).isPresent();
        }
    };
    public final boolean items;
    public final ArrayList<ItemStack> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public ItemStack liquidItem = ItemStack.f_41583_;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public ItemStack energyItem = ItemStack.f_41583_;

    public TrashCanBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, boolean items, boolean liquids, boolean energy) {
        super(blockEntityType, pos, state);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(ItemStack.f_41583_);
            this.liquidFilter.add(null);
        }
    }

    public void update() {
        if (this.liquids && !this.liquidItem.m_41619_() && this.liquidItem.m_41720_() != Items.f_42446_) {
            this.liquidItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
                boolean changed = false;
                for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                    if (fluidHandler.getFluidInTank(tank).isEmpty()) continue;
                    fluidHandler.drain(fluidHandler.getFluidInTank(tank), IFluidHandler.FluidAction.EXECUTE);
                    changed = true;
                }
                if (changed) {
                    this.liquidItem = fluidHandler.getContainer();
                    this.dataChanged();
                }
            });
            if (Compatibility.MEKANISM.drainGasFromItem(this.liquidItem)) {
                this.dataChanged();
            }
        }
        if (this.energy && !this.energyItem.m_41619_()) {
            this.energyItem.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
                energyStorage.extractEnergy(energyStorage.getEnergyStored(), false);
                this.dataChanged();
            });
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.items && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.ITEM_HANDLER).cast();
        }
        if (this.liquids) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return LazyOptional.of(() -> this.FLUID_HANDLER).cast();
            }
            if (Compatibility.MEKANISM.isInstalled() && cap == Compatibility.MEKANISM.getGasHandlerCapability()) {
                Object handler = Compatibility.MEKANISM.getGasHandler(this.liquidFilter, () -> this.liquidFilterWhitelist);
                return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> handler).cast();
            }
        }
        if (this.energy && cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.ENERGY_STORAGE).cast();
        }
        return LazyOptional.empty();
    }

    protected CompoundTag writeData() {
        int i;
        CompoundTag tag = new CompoundTag();
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                tag.m_128365_("itemFilter" + i, (Tag)this.itemFilter.get(i).m_41739_(new CompoundTag()));
            }
            tag.m_128379_("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                tag.m_128365_("liquidFilter" + i, (Tag)LiquidTrashCanFilters.write(this.liquidFilter.get(i)));
            }
            tag.m_128379_("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.m_41619_()) {
                tag.m_128365_("liquidItem", (Tag)this.liquidItem.m_41739_(new CompoundTag()));
            }
        }
        if (this.energy) {
            tag.m_128379_("useEnergyLimit", this.useEnergyLimit);
            tag.m_128405_("energyLimit", this.energyLimit);
            if (!this.energyItem.m_41619_()) {
                tag.m_128365_("energyItem", (Tag)this.energyItem.m_41739_(new CompoundTag()));
            }
        }
        return tag;
    }

    protected void readData(CompoundTag tag) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, tag.m_128441_("itemFilter" + i) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("itemFilter" + i)) : ItemStack.f_41583_);
            }
            boolean bl = this.itemFilterWhitelist = tag.m_128441_("itemFilterWhitelist") && tag.m_128471_("itemFilterWhitelist");
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, tag.m_128441_("liquidFilter" + i) ? LiquidTrashCanFilters.read(tag.m_128469_("liquidFilter" + i)) : null);
            }
            this.liquidFilterWhitelist = tag.m_128441_("liquidFilterWhitelist") && tag.m_128471_("liquidFilterWhitelist");
            ItemStack itemStack = this.liquidItem = tag.m_128441_("liquidItem") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("liquidItem")) : ItemStack.f_41583_;
        }
        if (this.energy) {
            this.useEnergyLimit = tag.m_128441_("useEnergyLimit") && tag.m_128471_("useEnergyLimit");
            this.energyLimit = tag.m_128441_("energyLimit") ? tag.m_128451_("energyLimit") : 10000;
            this.energyItem = tag.m_128441_("energyItem") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("energyItem")) : ItemStack.f_41583_;
        }
    }
}

