/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import xyz.przemyk.simpleplanes.container.CycleableContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class CyclePlaneInventoryPacket {
    private final Type type;

    public CyclePlaneInventoryPacket(Type type) {
        this.type = type;
    }

    public CyclePlaneInventoryPacket(FriendlyByteBuf buffer) {
        this.type = Type.values()[buffer.readByte()];
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            AbstractContainerMenu patt950$temp = sender.f_36096_;
            if (patt950$temp instanceof CycleableContainer) {
                CycleableContainer container = (CycleableContainer)patt950$temp;
                Entity patt1013$temp = sender.m_20202_();
                if (patt1013$temp instanceof PlaneEntity) {
                    PlaneEntity planeEntity = (PlaneEntity)patt1013$temp;
                    planeEntity.openContainer(sender, this.type == Type.LEFT ? container.cycleableContainerID() + 1 : container.cycleableContainerID() - 1);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum Type {
        LEFT,
        RIGHT;

    }
}

