/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.motschen.rocks.datagen;

import com.google.gson.JsonObject;
import eu.midnightdust.motschen.rocks.Rocks;
import eu.midnightdust.motschen.rocks.blockstates.StarfishVariation;
import eu.midnightdust.motschen.rocks.datagen.RocksModifiers;
import eu.midnightdust.motschen.rocks.registry.RocksRegistry;
import eu.midnightdust.motschen.rocks.world.configured_feature.MiscFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.NetherFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.RockFeatures;
import eu.midnightdust.motschen.rocks.world.configured_feature.StickFeatures;
import eu.midnightdust.motschen.rocks.world.modifier.AddFeaturesBlacklistBiomeModifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RocksDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new RocksBiomeTags(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(RocksDatagen::getProvider), Set.of("rocks")));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256911_, context -> {
            MiscFeatures.configuredBootstrap(context);
            NetherFeatures.configuredBootstrap(context);
            RockFeatures.configuredBootstrap(context);
            StickFeatures.configuredBootstrap(context);
        });
        registryBuilder.m_254916_(Registries.f_256988_, context -> {
            MiscFeatures.placedBootstrap((BootstapContext<PlacedFeature>)context);
            NetherFeatures.placedBootstrap((BootstapContext<PlacedFeature>)context);
            RockFeatures.placedBootstrap((BootstapContext<PlacedFeature>)context);
            StickFeatures.placedBootstrap((BootstapContext<PlacedFeature>)context);
        });
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
            List<HolderSet.Named> overworld = List.of(biomeGetter.m_254956_(BiomeTags.f_215817_));
            List<HolderSet.Named> rockBlacklist = List.of(biomeGetter.m_254956_(BiomeTags.f_207612_), biomeGetter.m_254956_(BiomeTags.f_215818_), biomeGetter.m_254956_(BiomeTags.f_207615_), biomeGetter.m_254956_(Tags.Biomes.IS_SANDY), biomeGetter.m_254956_(BiomeTags.f_207607_), biomeGetter.m_254956_(BiomeTags.f_207603_));
            context.m_255272_(RocksModifiers.ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.GRANITE_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_GRANITE_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.DIORITE_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_DIORITE_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.ANDESITE_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(overworld, rockBlacklist, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_ANDESITE_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.SAND_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207604_), biomeGetter.m_254956_(Tags.Biomes.IS_SANDY), biomeGetter.m_254956_(BiomeTags.f_207607_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_SAND_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.RED_SAND_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(Tags.Biomes.IS_SANDY), biomeGetter.m_254956_(BiomeTags.f_207607_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_RED_SAND_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.ENDSTONE_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_215818_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_END_STONE_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.OAK_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207611_), biomeGetter.m_254956_(Tags.Biomes.IS_PLAINS), biomeGetter.m_254956_(Tags.Biomes.IS_SWAMP)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_OAK_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.BIRCH_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207611_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_BIRCH_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.PINECONE_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207609_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_PINECONE_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.SPRUCE_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207609_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_SPRUCE_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.ACACIA_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_215816_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_ACACIA_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.JUNGLE_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207610_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_JUNGLE_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.BAMBOO_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207610_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_BAMBOO_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.DARK_OAK_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(RocksBiomeTags.IS_DARK_FOREST)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_DARK_OAK_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.MANGROVE_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(RocksBiomeTags.IS_MANGROVE_SWAMP)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_MANGROVE_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.CHERRY_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(RocksBiomeTags.IS_CHERRY_GROVE)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(StickFeatures.PLACED_CHERRY_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.SEASHELL_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207604_)), List.of(biomeGetter.m_254956_(Tags.Biomes.IS_SNOWY)), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(MiscFeatures.PLACED_SEASHELL_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.STARFISH_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207604_)), List.of(biomeGetter.m_254956_(Tags.Biomes.IS_SNOWY)), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(MiscFeatures.PLACED_STARFISH_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.UNDERWATER_SEASHELL_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207603_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(MiscFeatures.PLACED_UNDERWATER_SEASHELL_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.UNDERWATER_STARFISH_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207603_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(MiscFeatures.PLACED_UNDERWATER_STARFISH_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.SNOWY_GEYSER_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(Tags.Biomes.IS_SNOWY)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(MiscFeatures.PLACED_SNOWY_GEYSER_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.GRAVEL_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(overworld, List.of(biomeGetter.m_254956_(BiomeTags.f_207612_), biomeGetter.m_254956_(BiomeTags.f_215818_)), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_GRAVEL_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.GRAVEL_ROCK_NETHER_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(biomeGetter.m_254956_(BiomeTags.f_215818_), biomeGetter.m_254956_(BiomeTags.f_207612_)), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(RockFeatures.PLACED_GRAVEL_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.NETHERRACK_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_NETHERRACK_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.SOUL_SOIL_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_SOUL_SOIL_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.NETHER_GRAVEL_ROCK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_NETHER_GRAVEL_ROCK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.WARPED_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_WARPED_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.CRIMSON_STICK_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_CRIMSON_STICK_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
            context.m_255272_(RocksModifiers.NETHER_GEYSER_MODIFIER, (Object)new AddFeaturesBlacklistBiomeModifier(List.of(biomeGetter.m_254956_(BiomeTags.f_207612_)), List.of(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(NetherFeatures.PLACED_NETHER_GEYSER_FEATURE)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        });
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RocksBlockTables::new, LootContextParamSets.f_81421_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> table.m_79136_(validationContext));
        }

        public static class RocksBlockTables
        extends BlockLootSubProvider {
            private static final float[] NAUTILOUS_CHANCE = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

            protected RocksBlockTables() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            protected void m_245660_() {
                this.m_246125_((Block)RocksRegistry.ACACIA_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.BIRCH_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.CHERRY_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.CRIMSON_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.DARK_OAK_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.JUNGLE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.MANGROVE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.OAK_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.SPRUCE_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.WARPED_STICK.get(), (ItemLike)Items.f_42398_);
                this.m_246125_((Block)RocksRegistry.BAMBOO_STICK.get(), (ItemLike)Items.f_41911_);
                this.m_246125_((Block)RocksRegistry.PINECONE.get(), (ItemLike)Items.f_42800_);
                this.m_247577_((Block)RocksRegistry.SEASHELL.get(), this.createSeashellDrop((Block)RocksRegistry.SEASHELL.get()));
                this.m_247577_((Block)RocksRegistry.STARFISH.get(), this.createStarfishDrop((Block)RocksRegistry.STARFISH.get()));
                this.m_246125_((Block)RocksRegistry.ANDESITE_ROCK.get(), (ItemLike)RocksRegistry.ANDESITE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.DIORITE_ROCK.get(), (ItemLike)RocksRegistry.DIORITE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.END_STONE_ROCK.get(), (ItemLike)RocksRegistry.END_STONE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.GRANITE_ROCK.get(), (ItemLike)RocksRegistry.GRANITE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.NETHERRACK_ROCK.get(), (ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.RED_SAND_ROCK.get(), (ItemLike)RocksRegistry.RED_SAND_ROCK_ITEM.get());
                this.m_246125_((Block)RocksRegistry.ROCK.get(), (ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.SAND_ROCK.get(), (ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.SOUL_SOIL_ROCK.get(), (ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get());
                this.m_246125_((Block)RocksRegistry.GRAVEL_ROCK.get(), (ItemLike)Items.f_42484_);
                this.m_247577_((Block)RocksRegistry.GEYSER.get(), RocksBlockTables.m_246386_());
                this.m_247577_((Block)RocksRegistry.NETHER_GEYSER.get(), RocksBlockTables.m_246386_());
            }

            protected LootTable.Builder createSeashellDrop(Block block) {
                return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42715_).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NAUTILOUS_CHANCE)))));
            }

            protected LootTable.Builder createStarfishDrop(Block starFish) {
                return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)starFish, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)RocksBlockTables.getStarfishTag("red"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.RED)))))).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)starFish, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)RocksBlockTables.getStarfishTag("pink"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.PINK)))))).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)starFish, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)starFish).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)RocksBlockTables.getStarfishTag("orange"))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)starFish).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(Rocks.STARFISH_VARIATION, (Comparable)((Object)StarfishVariation.ORANGE)))))));
            }

            private static CompoundTag getStarfishTag(String color) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("variation", color);
                return tag;
            }

            protected Iterable<Block> getKnownBlocks() {
                return RocksRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(Consumer<FinishedRecipe> recipeConsumer) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50334_).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.ANDESITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "andesite_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50652_).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.COBBLESTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "cobblestone_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50228_).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.DIORITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "diorite_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50259_).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.END_STONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "end_stone_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50122_).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.GRANITE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "granite_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50134_).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.NETHERRACK_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "netherrack_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50394_).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.RED_SANDSTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "red_sandstone_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50062_).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SANDSTONE_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "sandstone_from_splitter"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50136_).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126209_((ItemLike)RocksRegistry.SOUL_SOIL_SPLITTER.get()).m_126132_("none", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42329_)).m_126140_(recipeConsumer, new ResourceLocation("rocks", "soul_soil_from_splitter"));
        }

        @Nullable
        protected CompletableFuture<?> saveAdvancement(CachedOutput output, FinishedRecipe finishedRecipe, JsonObject advancementJson) {
            return null;
        }
    }

    public static class RocksBiomeTags
    extends BiomeTagsProvider {
        public static final TagKey<Biome> IS_DARK_FOREST = RocksBiomeTags.create(new ResourceLocation("forge", "is_dark_forest"));
        public static final TagKey<Biome> IS_MANGROVE_SWAMP = RocksBiomeTags.create(new ResourceLocation("forge", "is_mangrove_swamp"));
        public static final TagKey<Biome> IS_CHERRY_GROVE = RocksBiomeTags.create(new ResourceLocation("forge", "is_cherry_grove"));

        public RocksBiomeTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "rocks", existingFileHelper);
        }

        private static TagKey<Biome> create(ResourceLocation location) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)location);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(IS_DARK_FOREST).m_255204_(Biomes.f_48151_);
            this.m_206424_(IS_MANGROVE_SWAMP).m_255204_(Biomes.f_220595_);
            this.m_206424_(IS_CHERRY_GROVE).m_255204_(Biomes.f_271432_);
        }
    }
}

