/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnvehicles.vehicle.truck;

import com.dragn0007.dragnvehicles.ValiantVehiclesMain;
import com.dragn0007.dragnvehicles.registry.ItemRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Truck
extends Entity
implements ContainerListener {
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(Truck.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Truck.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("dragnvehicles", "textures/entity/truck/white.png");
    private static final Map<DyeColor, ResourceLocation> COLOR_MAP = new HashMap<DyeColor, ResourceLocation>(){
        {
            this.put(DyeColor.BLACK, new ResourceLocation("dragnvehicles", "textures/entity/truck/black.png"));
            this.put(DyeColor.BLUE, new ResourceLocation("dragnvehicles", "textures/entity/truck/blue.png"));
            this.put(DyeColor.BROWN, new ResourceLocation("dragnvehicles", "textures/entity/truck/brown.png"));
            this.put(DyeColor.CYAN, new ResourceLocation("dragnvehicles", "textures/entity/truck/cyan.png"));
            this.put(DyeColor.GRAY, new ResourceLocation("dragnvehicles", "textures/entity/truck/gray.png"));
            this.put(DyeColor.LIGHT_BLUE, new ResourceLocation("dragnvehicles", "textures/entity/truck/light_blue.png"));
            this.put(DyeColor.LIGHT_GRAY, new ResourceLocation("dragnvehicles", "textures/entity/truck/light_gray.png"));
            this.put(DyeColor.LIME, new ResourceLocation("dragnvehicles", "textures/entity/truck/lime.png"));
            this.put(DyeColor.MAGENTA, new ResourceLocation("dragnvehicles", "textures/entity/truck/magenta.png"));
            this.put(DyeColor.ORANGE, new ResourceLocation("dragnvehicles", "textures/entity/truck/orange.png"));
            this.put(DyeColor.PINK, new ResourceLocation("dragnvehicles", "textures/entity/truck/pink.png"));
            this.put(DyeColor.PURPLE, new ResourceLocation("dragnvehicles", "textures/entity/truck/purple.png"));
            this.put(DyeColor.RED, new ResourceLocation("dragnvehicles", "textures/entity/truck/red.png"));
            this.put(DyeColor.WHITE, new ResourceLocation("dragnvehicles", "textures/entity/truck/white.png"));
            this.put(DyeColor.GREEN, new ResourceLocation("dragnvehicles", "textures/entity/truck/green.png"));
            this.put(DyeColor.YELLOW, new ResourceLocation("dragnvehicles", "textures/entity/truck/yellow.png"));
        }
    };
    private static final float MAX_HEALTH = 25.0f;
    private static final float SPEED = 0.15f;
    private static final float TURN_SPEED = 1.0f;
    private static final float MAX_TURN = 6.0f;
    private static final float FRICTION = 0.7f;
    private static final float GRAVITY = 0.08f;
    private float targetRotation = 0.0f;
    private float currentRotation = 0.0f;
    public int forwardMotion = 1;
    public int driveTick = 0;
    public float lastDrivePartialTick = 0.0f;
    public Vec3 lastClientPos = Vec3.f_82478_;
    public SimpleContainer inventory;
    private LazyOptional<?> itemHandler;
    private int lerpSteps;
    private double targetX;
    private double targetY;
    private double targetZ;
    private float targetYRot;

    public Truck(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.createInventory();
    }

    private void createInventory() {
        this.inventory = new SimpleContainer(54);
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.m_6084_() && cap == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    private Vec3 calcOffset(double x, double y, double z) {
        double rad = (double)this.m_146908_() * Math.PI / 180.0;
        double xOffset = this.m_20182_().f_82479_ + (x * Math.cos(rad) - z * Math.sin(rad));
        double yOffset = this.m_20182_().f_82480_ + y;
        double zOffset = this.m_20182_().f_82481_ + (x * Math.sin(rad) + z * Math.cos(rad));
        return new Vec3(xOffset, yOffset, zOffset);
    }

    public void updateLastDrivePartialTick(float partialTick) {
        double xStep = this.m_20182_().f_82479_ - this.lastClientPos.f_82479_;
        double zStep = this.m_20182_().f_82481_ - this.lastClientPos.f_82481_;
        if (xStep * xStep + zStep * zStep != 0.0) {
            this.lastDrivePartialTick = partialTick;
        }
    }

    public void calcAnimStep() {
        double xStep = this.m_20182_().f_82479_ - this.lastClientPos.f_82479_;
        double zStep = this.m_20182_().f_82481_ - this.lastClientPos.f_82481_;
        float deg = (float)(Math.atan2(xStep, zStep) * 180.0 / Math.PI);
        if (xStep * xStep + zStep * zStep != 0.0) {
            this.driveTick = (this.driveTick + 1) % 30;
            this.forwardMotion = Math.round(ValiantVehiclesMain.mod(this.m_146908_(), 360.0f) + deg) == 180 ? -1 : 1;
        }
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < 2;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        int i = this.m_20197_().indexOf(entity);
        switch (i) {
            case 0: {
                entity.m_146884_(this.calcOffset(0.6, 0.3, -0.2));
                break;
            }
            case 1: {
                entity.m_146884_(this.calcOffset(-0.6, 0.3, -0.2));
            }
        }
    }

    public double m_6048_() {
        return -1.0;
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_5834_();
            this.m_146850_(GameEvent.f_223706_);
            float health = ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - damage;
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(health));
            if (health < 0.0f) {
                Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.inventory);
                this.m_19998_((ItemLike)ItemRegistry.TRUCK_SPAWN_EGG.get());
                this.m_6074_();
            }
        }
        return true;
    }

    public LivingEntity m_6688_() {
        return (LivingEntity)this.m_146895_();
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean p_19902_) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetYRot = yRot;
        this.lerpSteps = lerpSteps;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleInput(Input input) {
        float forward = 0.0f;
        float turn = 0.0f;
        int turnMod = 1;
        if (input.f_108568_) {
            forward = 0.15f;
        }
        if (input.f_108569_) {
            forward = -0.15f;
            turnMod = -1;
        }
        if (input.f_108570_) {
            turn = -1.0f * (float)turnMod;
        }
        if (input.f_108571_) {
            turn = 1.0f * (float)turnMod;
        }
        this.currentRotation = this.targetRotation;
        if (Math.abs(this.targetRotation + turn) <= 6.0f) {
            this.targetRotation += turn;
        }
        if (forward != 0.0f && turn == 0.0f) {
            this.targetRotation = 0.0f;
        }
        float deg = this.currentRotation + this.m_146908_();
        float rad = deg * (float)Math.PI / 180.0f;
        if (forward != 0.0f && deg != this.m_146908_()) {
            this.m_146922_(deg);
        }
        this.m_20256_(this.m_20184_().m_82520_(-Math.sin(rad) * (double)forward, 0.0, Math.cos(rad) * (double)forward));
    }

    public void m_8119_() {
        super.m_8119_();
        this.lastClientPos = this.m_20182_();
        if (this.m_6109_()) {
            double dz;
            this.lerpSteps = 0;
            Vec3 velocity = this.m_20184_();
            double dx = velocity.f_82479_ * (double)0.7f;
            if (Math.abs(dx) < 0.001) {
                dx = 0.0;
            }
            if (Math.abs(dz = velocity.f_82481_ * (double)0.7f) < 0.001) {
                dz = 0.0;
            }
            double dy = velocity.f_82480_ + (double)(this.m_20096_() ? 0.0f : -0.08f);
            this.m_20334_(dx, dy, dz);
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)livingEntity;
                this.handleInput(player.f_108618_);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.lastClientPos.f_82479_ != this.m_20182_().f_82479_ || this.lastClientPos.f_82480_ != this.m_20182_().f_82480_ || this.lastClientPos.f_82481_ != this.m_20182_().f_82481_) {
                this.m_217006_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
            }
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.lerpSteps > 0) {
            double x = this.m_20185_() + (this.targetX - this.m_20185_()) / (double)this.lerpSteps;
            double y = this.m_20186_() + (this.targetY - this.m_20186_()) / (double)this.lerpSteps;
            double z = this.m_20189_() + (this.targetZ - this.m_20189_()) / (double)this.lerpSteps;
            float yRot = this.m_146908_() + (this.targetYRot - this.m_146908_()) / (float)this.lerpSteps;
            this.m_6034_(x, y, z);
            this.m_146922_(yRot);
            --this.lerpSteps;
        }
        this.calcAnimStep();
    }

    public float getFrontWheelRotation(float time) {
        return (this.currentRotation + (this.targetRotation - this.currentRotation) * time) * (float)Math.PI / 180.0f;
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            Item item = itemStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                this.m_9236_().m_6269_(player, (Entity)this, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.m_9236_().f_46443_) {
                    this.setTexture(COLOR_MAP.get(dyeItem.m_41089_()).toString());
                    itemStack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, serverPlayer) -> ChestMenu.m_39246_((int)containerId, (Inventory)inventory, (Container)this.inventory), this.m_5446_()));
            }
        } else if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return super.m_6096_(player, hand);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEXTURE, (Object)DEFAULT_TEXTURE.toString());
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(25.0f));
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.f_19804_.m_135381_(TEXTURE, (Object)compoundTag.m_128461_("Texture"));
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compoundTag.m_128457_("Health")));
        this.createInventory();
        ListTag listTag = compoundTag.m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int j = tag.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)tag));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128359_("Texture", ((String)this.f_19804_.m_135370_(TEXTURE)).toString());
        compoundTag.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(tag);
            listTag.add((Object)tag);
        }
        compoundTag.m_128365_("Items", (Tag)listTag);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_5757_(Container container) {
    }
}

