/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnvehicles.vehicle.motorcycle;

import com.dragn0007.dragnvehicles.Animation;
import com.dragn0007.dragnvehicles.vehicle.motorcycle.Motorcycle;
import com.dragn0007.dragnvehicles.vehicle.motorcycle.MotorcycleRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class MotorcycleModel<T extends Entity>
extends EntityModel<Motorcycle> {
    private final ModelPart Body;
    private final ModelPart Handles;
    private final ModelPart FrontWheel;
    private final ModelPart BackWheel;

    public MotorcycleModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Handles = root.m_171324_("Handles");
        this.FrontWheel = root.m_171324_("FrontWheel");
        this.BackWheel = root.m_171324_("BackWheel");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(-6.0f, -5.0307f, -10.3582f, 12.0f, 15.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(106, 91).m_171488_(-5.0f, -7.0307f, -10.3582f, 10.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(62, 85).m_171488_(-5.0f, -8.0307f, 8.6418f, 10.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(66, 60).m_171488_(-5.0f, -8.0307f, -26.3582f, 10.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(50, 135).m_171488_(-3.0f, -7.0307f, -28.3582f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0307f, (float)3.3582f));
        PartDefinition cube_r1 = Body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(42, 106).m_171488_(-4.0f, -8.5f, -8.0f, 8.0f, 18.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.3601f, (float)16.1182f, (float)-1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = Body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(-1.0f, -2.0981f, -1.1699f, 6.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-0.7807f, (float)10.0748f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = Body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(118, 60).m_171488_(-4.0f, -8.5f, -1.0f, 8.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.3601f, (float)-17.8346f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = Body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(126, 48).m_171488_(-8.0f, -5.5f, 0.0f, 16.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.3807f, (float)-19.3582f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = Body.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-8.0f, -2.0f, -13.0f, 4.0f, 4.0f, 29.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(4.0f, -2.0f, -13.0f, 4.0f, 4.0f, 29.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.9693f, (float)8.6418f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = Body.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(-8.0f, -2.0f, -13.0f, 4.0f, 4.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(66, 0).m_171488_(4.0f, -2.0f, -13.0f, 4.0f, 4.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.9693f, (float)6.6418f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Handles = partdefinition.m_171599_("Handles", CubeListBuilder.m_171558_().m_171514_(106, 85).m_171488_(-12.0f, -2.5f, -1.5f, 24.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-10.5f));
        PartDefinition cube_r7 = Handles.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(-1.0f, -2.0981f, -13.8301f, 6.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)7.75f, (float)2.067f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition FrontWheel = partdefinition.m_171599_("FrontWheel", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-2.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)-16.5f));
        PartDefinition cube_r8 = FrontWheel.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = FrontWheel.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = FrontWheel.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition BackWheel = partdefinition.m_171599_("BackWheel", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-2.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)21.5f));
        PartDefinition cube_r11 = BackWheel.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = BackWheel.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = BackWheel.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(-1.0f, -8.5f, -3.5f, 4.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Handles.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontWheel.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BackWheel.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void prepareMobModel(Motorcycle motorcycle, float p_102615_, float p_102616_, float partialTick) {
        Animation.animate(this.Body, MotorcycleRender.BODY_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
        Animation.animate(this.FrontWheel, MotorcycleRender.FRONT_WHEEL_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
        Animation.animate(this.BackWheel, MotorcycleRender.BACK_WHEEL_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
    }

    public void setupAnim(Motorcycle motorcycle, float partialTick, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        motorcycle.updateLastDrivePartialTick(partialTick);
        Animation.animate(this.Body, MotorcycleRender.BODY_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
        Animation.animate(this.FrontWheel, MotorcycleRender.FRONT_WHEEL_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
        Animation.animate(this.BackWheel, MotorcycleRender.BACK_WHEEL_ANIMATION, motorcycle.driveTick, motorcycle.lastDrivePartialTick, motorcycle.forwardMotion);
        this.FrontWheel.f_104204_ = motorcycle.getFrontWheelRotation(partialTick);
        this.Handles.f_104204_ = motorcycle.getHandleRotation(partialTick);
    }
}

