/*
 * Decompiled with CFR 0.152.
 */
package net.marblednull.shotsfired.util;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LaunchItemUtil {
    public static void spawnAndLaunchItem(Player player, double forwardDist, double rightDist, double upDist, double yawOffsetDeg, double pitchOffsetDeg, double rollOffsetDeg, double speed, Item casingItem) {
        Level level = player.m_9236_();
        Vec3 forward = player.m_20154_().m_82541_();
        float yawRad = (float)Math.toRadians(-player.m_146908_());
        Vec3 right = new Vec3(Math.cos(yawRad), 0.0, -Math.sin(yawRad)).m_82541_();
        Vec3 up = right.m_82537_(forward).m_82541_();
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 spawnPos = eyePos.m_82549_(forward.m_82490_(forwardDist)).m_82549_(right.m_82490_(rightDist)).m_82549_(up.m_82490_(upDist));
        Vec3 launchDir = LaunchItemUtil.rotateDirection(forward, right, up, yawOffsetDeg, pitchOffsetDeg, rollOffsetDeg);
        ItemStack casingStack = new ItemStack((ItemLike)casingItem);
        ItemEntity casingEntity = new ItemEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, casingStack);
        casingEntity.m_20256_(launchDir.m_82490_(speed));
        casingEntity.m_32060_();
        player.m_9236_().m_7967_((Entity)casingEntity);
    }

    private static Vec3 rotateDirection(Vec3 forward, Vec3 right, Vec3 up, double yawDeg, double pitchDeg, double rollDeg) {
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double roll = Math.toRadians(rollDeg);
        Vec3 dir = forward;
        dir = LaunchItemUtil.rotateAroundAxis(dir, up, yaw);
        dir = LaunchItemUtil.rotateAroundAxis(dir, right, pitch);
        dir = LaunchItemUtil.rotateAroundAxis(dir, forward, roll);
        return dir.m_82541_();
    }

    private static Vec3 rotateAroundAxis(Vec3 vec, Vec3 axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return vec.m_82490_(cos).m_82549_(axis.m_82537_(vec).m_82490_(sin)).m_82549_(axis.m_82490_(axis.m_82526_(vec) * (1.0 - cos)));
    }
}

