/*
 * Decompiled with CFR 0.152.
 */
package net.marblednull.shotsfired;

import com.mojang.logging.LogUtils;
import com.tacz.guns.api.event.common.GunFireEvent;
import java.util.Map;
import net.marblednull.shotsfired.config.TACZConfig;
import net.marblednull.shotsfired.config.TACZEjectionConfig;
import net.marblednull.shotsfired.util.DropData;
import net.marblednull.shotsfired.util.LaunchItemUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class ModEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RandomSource randomBulletChance = RandomSource.m_216327_();

    public static void spawnCasing(GunFireEvent gunEvent, Item casingItem, double dropChance, String gunId) {
        if (dropChance >= (double)(randomBulletChance.m_188501_() * 100.0f)) {
            TACZEjectionConfig.EjectionInfo ejectionInfoByGun;
            Map ejectionConfigMap = (Map)TACZEjectionConfig.EJECTION_MAP.get();
            if (ejectionConfigMap.containsKey(gunId)) {
                ejectionInfoByGun = (TACZEjectionConfig.EjectionInfo)ejectionConfigMap.get(gunId);
            } else {
                ejectionInfoByGun = (TACZEjectionConfig.EjectionInfo)ejectionConfigMap.get("fallback");
                LOGGER.warn("No ejection config found for {}, using fallback config", (Object)gunId);
            }
            Player player = (Player)gunEvent.getShooter();
            double forwardOffset = ejectionInfoByGun.offsetX();
            double sideOffset = ejectionInfoByGun.offsetY();
            double upOffset = ejectionInfoByGun.offsetZ();
            double yawOffset = ejectionInfoByGun.rotationYawDeg();
            double pitchOffset = ejectionInfoByGun.rotationPitchDeg();
            double rollOffset = ejectionInfoByGun.rotationRollDeg();
            double velocity = ejectionInfoByGun.velocity();
            LaunchItemUtil.spawnAndLaunchItem(player, forwardOffset, sideOffset, upOffset, yawOffset, pitchOffset, rollOffset, velocity, casingItem);
        }
    }

    public static void weaponShootEvent(GunFireEvent gunEvent) {
        String gunId;
        Map gunItemMap;
        if (gunEvent.getLogicalSide().isServer() && (gunItemMap = (Map)TACZConfig.TACZ.get()).containsKey(gunId = gunEvent.getGunItemStack().m_41783_().m_128461_("GunId"))) {
            Item casingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(((DropData)gunItemMap.get((Object)gunId)).item));
            float dropChance = ((DropData)gunItemMap.get((Object)gunId)).chance;
            ModEvents.spawnCasing(gunEvent, casingItem, dropChance, gunId);
        }
    }
}

