/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb.resource;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.item.GunTabType;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import mod.cdv.gdb.DataLookup;
import mod.cdv.gdb.Util;
import mod.cdv.gdb.network.NetworkHandler;
import mod.cdv.gdb.network.SyncGunModifiersPacket;
import mod.cdv.gdb.resource.GunModifier;
import mod.cdv.gdb.resource.StatModifier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ResourceLoader
extends SimpleJsonResourceReloadListener {
    public static final ResourceLoader INSTANCE = new ResourceLoader();

    public ResourceLoader() {
        super(new Gson(), "gundb");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        TreeMap gunModifiers = new TreeMap((a, b) -> {
            boolean aIsGunDb = a.m_135827_().equals("gundb");
            boolean bIsGunDb = b.m_135827_().equals("gundb");
            if (aIsGunDb && !bIsGunDb) {
                return 1;
            }
            if (!aIsGunDb && bIsGunDb) {
                return -1;
            }
            int nsCompare = a.m_135827_().compareTo(b.m_135827_());
            if (nsCompare != 0) {
                return nsCompare;
            }
            return a.m_135815_().compareTo(b.m_135815_());
        });
        map.forEach((re, e) -> {
            Either target;
            JsonObject root = e.getAsJsonObject();
            String name = re.m_135815_();
            name = name.replace('/', ':');
            switch (name.toLowerCase()) {
                case "pistol": {
                    Either either = Either.left((Object)GunTabType.PISTOL);
                    break;
                }
                case "mg": {
                    Either either = Either.left((Object)GunTabType.MG);
                    break;
                }
                case "smg": {
                    Either either = Either.left((Object)GunTabType.SMG);
                    break;
                }
                case "rifle": {
                    Either either = Either.left((Object)GunTabType.RIFLE);
                    break;
                }
                case "rpg": {
                    Either either = Either.left((Object)GunTabType.RPG);
                    break;
                }
                case "sniper": {
                    Either either = Either.left((Object)GunTabType.SNIPER);
                    break;
                }
                case "shotgun": {
                    Either either = Either.left((Object)GunTabType.SHOTGUN);
                    break;
                }
                default: {
                    Either either = target = Either.right((Object)ResourceLocation.parse((String)name));
                }
            }
            if (root.has("enabled") && !root.get("enabled").getAsBoolean()) {
                gunModifiers.put(re, GunModifier.createDisabled((Either<GunTabType, ResourceLocation>)target));
                return;
            }
            String repairItemRaw = root.getAsJsonPrimitive("RepairItem").getAsString();
            System.out.println("Found: " + String.valueOf(re));
            int maxDurability = root.has("MaxDurability") ? root.get("MaxDurability").getAsInt() : 1500;
            int repairCost = root.has("RepairCost") ? root.get("RepairCost").getAsInt() : 5;
            float xpCost = root.has("XpCost") ? root.get("XpCost").getAsFloat() : 0.5f;
            boolean preventFiring = root.has("FireOnZero") && root.get("FireOnZero").getAsBoolean();
            boolean jam = root.has("Jam") && root.get("Jam").getAsBoolean();
            float jamChance = root.has("JamChance") ? root.get("JamChance").getAsFloat() : 0.2f;
            float jamThreshold = root.has("JamThreshold") ? root.get("JamThreshold").getAsFloat() : 0.75f;
            int jamTimeMS = root.has("JamTimeMS") ? root.get("JamTimeMS").getAsInt() : 2000;
            Ingredient repairItem = repairItemRaw.startsWith("#") ? Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.parse((String)repairItemRaw.substring(1)))) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)repairItemRaw))});
            JsonArray statsArr = root.getAsJsonArray("Stats");
            ArrayList<StatModifier> statsTemp = new ArrayList<StatModifier>();
            for (JsonElement jsonElement : statsArr) {
                JsonObject obj = jsonElement.getAsJsonObject();
                JsonElement typeElement = obj.get("Type");
                GunProperty[] gunProperties = new GunProperty[]{};
                if (typeElement.isJsonPrimitive()) {
                    gunProperties = new GunProperty[]{Util.getGunProperty(typeElement.getAsString())};
                } else if (typeElement.isJsonArray()) {
                    ArrayList propTemp = new ArrayList();
                    for (JsonElement prop : typeElement.getAsJsonArray()) {
                        propTemp.add(Util.getGunProperty(prop.getAsString()));
                    }
                    gunProperties = (GunProperty[])propTemp.toArray(GunProperty[]::new);
                }
                statsTemp.add(new StatModifier(gunProperties, obj.get("ReductionThreshold").getAsFloat(), obj.get("MaxReduction").getAsFloat()));
            }
            gunModifiers.put(re, new GunModifier((StatModifier[])statsTemp.toArray(StatModifier[]::new), repairItem, (Either<GunTabType, ResourceLocation>)target, maxDurability, repairCost, xpCost, preventFiring, jam, jamChance, jamThreshold, jamTimeMS));
        });
        ArrayList<GunModifier> finalModifiers = new ArrayList<GunModifier>(gunModifiers.values());
        DataLookup.gunModifiers.clear();
        DataLookup.modifierCache.clear();
        DataLookup.gunModifiers.addAll(finalModifiers);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            NetworkHandler.sendToAllClients(new SyncGunModifiersPacket(finalModifiers));
        }
    }
}

