/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb.network;

import com.mojang.datafixers.util.Either;
import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.item.GunTabType;
import java.util.ArrayList;
import java.util.function.Supplier;
import mod.cdv.gdb.DataLookup;
import mod.cdv.gdb.resource.GunModifier;
import mod.cdv.gdb.resource.StatModifier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.NetworkEvent;

public record SyncGunModifiersPacket(ArrayList<GunModifier> modifiers) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.modifiers.size());
        for (GunModifier modifier : this.modifiers) {
            buf.writeBoolean(modifier.enabled());
            buf.writeInt(modifier.modifiers().length);
            for (StatModifier statMod : modifier.modifiers()) {
                SyncGunModifiersPacket.encodeStatModifier(buf, statMod);
            }
            modifier.repairItem().m_43923_(buf);
            SyncGunModifiersPacket.encodeTarget(buf, modifier.target());
            buf.writeInt(modifier.maxDurability());
            buf.writeInt(modifier.repairCost());
            buf.writeFloat(modifier.xpCost());
            buf.writeBoolean(modifier.preventFiring());
            buf.writeBoolean(modifier.jam());
            buf.writeFloat(modifier.jamChance());
            buf.writeFloat(modifier.jamThreshold());
            buf.writeInt(modifier.jamTimeMS());
        }
    }

    public static SyncGunModifiersPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<GunModifier> modifiers = new ArrayList<GunModifier>();
        for (int i = 0; i < size; ++i) {
            boolean enabled = buf.readBoolean();
            int modifierCount = buf.readInt();
            StatModifier[] statModifiers = new StatModifier[modifierCount];
            for (int j = 0; j < modifierCount; ++j) {
                statModifiers[j] = SyncGunModifiersPacket.decodeStatModifier(buf);
            }
            Ingredient repairItem = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Either<GunTabType, ResourceLocation> target = SyncGunModifiersPacket.decodeTarget(buf);
            int maxDurability = buf.readInt();
            int repairCost = buf.readInt();
            float xpCost = buf.readFloat();
            boolean preventFiring = buf.readBoolean();
            boolean jam = buf.readBoolean();
            float jamChance = buf.readFloat();
            float jamThreshold = buf.readFloat();
            int jamTimeMS = buf.readInt();
            modifiers.add(new GunModifier(enabled, statModifiers, repairItem, target, maxDurability, repairCost, xpCost, preventFiring, jam, jamChance, jamThreshold, jamTimeMS));
        }
        return new SyncGunModifiersPacket(modifiers);
    }

    private static void encodeStatModifier(FriendlyByteBuf buf, StatModifier statMod) {
        buf.writeInt(statMod.types().length);
        for (GunProperty<?> prop : statMod.types()) {
            buf.m_130070_(prop.name());
        }
        buf.writeFloat(statMod.reductionThreshold());
        buf.writeFloat(statMod.maxReduction());
    }

    private static StatModifier decodeStatModifier(FriendlyByteBuf buf) {
        int typeCount = buf.readInt();
        GunProperty[] types = new GunProperty[typeCount];
        for (int i = 0; i < typeCount; ++i) {
            String propName = buf.m_130277_();
            types[i] = GunProperty.of((String)propName, Object.class);
        }
        float reductionThreshold = buf.readFloat();
        float maxReduction = buf.readFloat();
        return new StatModifier(types, reductionThreshold, maxReduction);
    }

    private static void encodeTarget(FriendlyByteBuf buf, Either<GunTabType, ResourceLocation> target) {
        target.ifLeft(tabType -> {
            buf.writeBoolean(true);
            buf.m_130070_(tabType.name());
        }).ifRight(gunId -> {
            buf.writeBoolean(false);
            buf.m_130070_(gunId.toString());
        });
    }

    private static Either<GunTabType, ResourceLocation> decodeTarget(FriendlyByteBuf buf) {
        boolean isTabType = buf.readBoolean();
        if (isTabType) {
            String tabTypeName = buf.m_130277_();
            GunTabType tabType = GunTabType.valueOf((String)tabTypeName.toUpperCase());
            return Either.left((Object)tabType);
        }
        String gunId = buf.m_130277_();
        return Either.right((Object)ResourceLocation.parse((String)gunId));
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DataLookup.setModifiers(this.modifiers);
            System.out.println("Client Modifiers:" + String.valueOf(this.modifiers));
        });
        context.setPacketHandled(true);
    }
}

