/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb.network;

import java.util.function.Supplier;
import mod.cdv.gdb.DataLookup;
import mod.cdv.gdb.GunDurability;
import mod.cdv.gdb.TimedWork;
import mod.cdv.gdb.network.NetworkHandler;
import mod.cdv.gdb.network.SyncJammedPacket;
import mod.cdv.gdb.resource.GunModifier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record StartJamWorkerPacket() {
    public void encode(FriendlyByteBuf buf) {
    }

    public static StartJamWorkerPacket decode(FriendlyByteBuf buf) {
        return new StartJamWorkerPacket();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() == null) {
                return;
            }
            ServerPlayer plr = context.getSender();
            GunModifier modifiers = DataLookup.getModifiers(plr.m_21205_());
            if (modifiers != null) {
                GunDurability.jamWorker.put((LivingEntity)plr, new TimedWork<LivingEntity>(modifiers.jamTimeMS(), p -> {
                    ItemStack item = p.m_21205_();
                    if (item.m_41783_() != null && item.m_41783_().m_128441_("Jammed") && item.m_41783_().m_128471_("Jammed")) {
                        item.m_41783_().m_128379_("Jammed", false);
                        NetworkHandler.sendToClient(new SyncJammedPacket(false), plr);
                    }
                    if (p instanceof ServerPlayer) {
                        ServerPlayer p2 = (ServerPlayer)p;
                        p2.m_213846_((Component)Component.m_264568_((String)"gundb.text.unjam", (String)"Jam Cleared"));
                    }
                }));
            }
        });
        context.setPacketHandled(true);
    }
}

