/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb.jei;

import com.tacz.guns.init.ModCreativeTabs;
import com.tacz.guns.item.ModernKineticGunItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mod.cdv.gdb.DataLookup;
import mod.cdv.gdb.resource.GunModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JeiRepairPlugin
implements IModPlugin {
    static final ResourceLocation pluginUid = ResourceLocation.fromNamespaceAndPath((String)"gundb", (String)"jei");

    public ResourceLocation getPluginUid() {
        return pluginUid;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        registration.addRecipes(RecipeTypes.ANVIL, this.getGunRecipes(vanillaRecipeFactory, ingredientManager));
    }

    private List<IJeiAnvilRecipe> getGunRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        HashMap<ResourceLocation, IJeiAnvilRecipe> recipes = new HashMap<ResourceLocation, IJeiAnvilRecipe>();
        for (RegistryObject entry : ModCreativeTabs.TABS.getEntries()) {
            ((CreativeModeTab)entry.get()).m_260957_();
            for (ItemStack allItemStack : ingredientManager.getAllItemStacks()) {
                Item item = allItemStack.m_41720_();
                if (!(item instanceof ModernKineticGunItem)) continue;
                ModernKineticGunItem gd = (ModernKineticGunItem)item;
                GunModifier mod = DataLookup.getModifiers(allItemStack);
                if (mod == null || !mod.enabled()) continue;
                ItemStack noDurabilityItem = allItemStack.m_41777_();
                noDurabilityItem.m_41721_(allItemStack.m_41776_());
                recipes.putIfAbsent(gd.getGunId(noDurabilityItem), vanillaRecipeFactory.createAnvilRecipe(noDurabilityItem, Arrays.stream(mod.repairItem().m_43908_()).map(i -> i.m_255036_(mod.repairCost())).toList(), List.of(allItemStack), gd.getGunId(noDurabilityItem)));
            }
        }
        return new ArrayList<IJeiAnvilRecipe>(recipes.values());
    }
}

