/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb;

import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.GunProperty;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class Util {
    public static <T> T getOrSetTag(ItemStack stack, String key, T defaultValue) {
        if (!stack.m_41782_()) {
            return defaultValue;
        }
        if (!stack.m_41783_().m_128441_(key)) {
            switch (defaultValue.getClass().getSimpleName()) {
                case "int": 
                case "Integer": {
                    stack.m_41783_().m_128405_(key, ((Integer)defaultValue).intValue());
                    break;
                }
                case "boolean": 
                case "Boolean": {
                    stack.m_41783_().m_128379_(key, ((Boolean)defaultValue).booleanValue());
                    break;
                }
                case "String": {
                    stack.m_41783_().m_128359_(key, (String)defaultValue);
                    break;
                }
                case "CompoundTag": 
                case "Tag": {
                    stack.m_41783_().m_128365_(key, (Tag)defaultValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + defaultValue.getClass().getSimpleName());
                }
            }
        }
        return (T)(switch (defaultValue.getClass().getSimpleName()) {
            case "int", "Integer" -> stack.m_41783_().m_128451_(key);
            case "boolean", "Boolean" -> stack.m_41783_().m_128471_(key);
            case "String" -> stack.m_41783_().m_128461_(key);
            case "CompoundTag" -> stack.m_41783_().m_128469_(key);
            default -> throw new IllegalStateException("Unexpected value: " + defaultValue.getClass().getSimpleName());
        });
    }

    public static GunProperty<?> getGunProperty(String prop) {
        return switch (prop.toLowerCase()) {
            case "ammospeed" -> GunProperties.AMMO_SPEED;
            case "weight" -> GunProperties.WEIGHT;
            case "damage" -> GunProperties.DAMAGE;
            case "ads" -> GunProperties.ADS_TIME;
            case "armorignore" -> GunProperties.ARMOR_IGNORE;
            case "inaccuracy" -> GunProperties.INACCURACY;
            case "range" -> GunProperties.EFFECTIVE_RANGE;
            case "speed" -> GunProperties.MOVE_SPEED;
            case "headshot" -> GunProperties.HEADSHOT_MULTIPLIER;
            case "knockback" -> GunProperties.KNOCKBACK;
            case "pierce" -> GunProperties.PIERCE;
            case "recoil" -> GunProperties.RECOIL;
            case "rpm" -> GunProperties.ROUNDS_PER_MINUTE;
            default -> throw new IllegalStateException("Unexpected value: " + prop);
        };
    }

    public static float remap(float value, float new_min, float new_max, float old_min, float old_max) {
        return new_min + (new_max - new_min) * ((value - old_min) / (old_max - old_min));
    }
}

