/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb;

import java.util.function.Consumer;

public class TimedWork<T> {
    public long startTimestamp;
    final long timeMS;
    final Consumer<T> action;

    public TimedWork(long timeMS, Consumer<T> action) {
        this.timeMS = timeMS;
        this.action = action;
        this.startTimestamp = System.currentTimeMillis();
    }

    public void start() {
        this.startTimestamp = System.currentTimeMillis();
    }

    public boolean poll(T actor) {
        if (System.currentTimeMillis() - this.startTimestamp > this.timeMS) {
            this.action.accept(actor);
            return true;
        }
        return false;
    }
}

