/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb;

import com.tacz.guns.api.GunProperty;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.AttachmentPropertyEvent;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.modifier.ParameterizedCachePair;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import mod.cdv.gdb.ClientEvents;
import mod.cdv.gdb.DataLookup;
import mod.cdv.gdb.TimedWork;
import mod.cdv.gdb.Util;
import mod.cdv.gdb.network.NetworkHandler;
import mod.cdv.gdb.network.SyncDamageNBTPacket;
import mod.cdv.gdb.network.SyncGunModifiersPacket;
import mod.cdv.gdb.network.SyncJammedPacket;
import mod.cdv.gdb.resource.GunModifier;
import mod.cdv.gdb.resource.ResourceLoader;
import mod.cdv.gdb.resource.StatModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="gundb")
public class GunDurability {
    public static final String MODID = "gundb";
    public static final Logger LOGGER = Logger.getLogger("gundb");
    public static final HashMap<LivingEntity, TimedWork<LivingEntity>> jamWorker = new HashMap();
    public static final Random random = new Random();

    public GunDurability() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::addReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::fireEvent);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::onPlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::onEquipmentSwap);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(GunDurability::anvilChangeEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, GunDurability::attachmentPropertyEvent);
        NetworkHandler.register();
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<GunModifier> modifiers = DataLookup.getAllModifiers();
            if (!modifiers.isEmpty() && ServerLifecycleHooks.getCurrentServer() != null) {
                NetworkHandler.sendToClient(new SyncGunModifiersPacket(modifiers), player2);
            }
        }
    }

    public static void onEquipmentSwap(LivingEquipmentChangeEvent event) {
        ItemStack item;
        GunModifier modifiers;
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21205_().m_41720_() instanceof ModernKineticGunItem && (modifiers = DataLookup.getModifiers(item = player.m_21205_())) != null) {
            jamWorker.remove(player);
        }
    }

    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        ItemStack item;
        GunModifier modifiers;
        if (event.getEntity().m_21205_().m_41720_() instanceof ModernKineticGunItem && (modifiers = DataLookup.getModifiers(item = event.getEntity().m_21205_())) != null && jamWorker.get(event.getEntity()) != null) {
            jamWorker.get(event.getEntity()).poll(event.getEntity());
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ResourceLoader.INSTANCE);
    }

    public static void fireEvent(GunFireEvent event) {
        LivingEntity livingEntity;
        ItemStack item = event.getGunItemStack();
        if (event.getLogicalSide().isClient()) {
            return;
        }
        GunModifier modifiers = DataLookup.getModifiers(item);
        if (modifiers == null) {
            return;
        }
        if (item.m_41783_() != null && item.m_41783_().m_128441_("Jammed") && item.m_41783_().m_128471_("Jammed")) {
            event.setCanceled(true);
            return;
        }
        if (item.m_41773_() == item.m_41776_()) {
            if (!modifiers.preventFiring()) {
                event.setCanceled(true);
            }
            return;
        }
        float durabilityPercent = ((float)item.m_41776_() - (float)item.m_41773_()) / (float)item.m_41776_();
        if (modifiers.jam() && durabilityPercent <= modifiers.jamThreshold()) {
            float chance = durabilityPercent;
            float chance2 = chance = Util.remap(chance, 0.0f, modifiers.jamChance(), modifiers.jamThreshold(), 0.0f);
            chance *= (float)Math.random();
            if ((chance += chance2) > modifiers.jamChance()) {
                item.m_41783_().m_128379_("Jammed", true);
                livingEntity = event.getShooter();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer plr = (ServerPlayer)livingEntity;
                    NetworkHandler.sendToClient(new SyncJammedPacket(true), plr);
                }
            }
        }
        AttachmentPropertyManager.postChangeEvent((LivingEntity)event.getShooter(), (ItemStack)item);
        int level = event.getGunItemStack().getEnchantmentLevel(Enchantments.f_44986_);
        if (level > 0 && random.nextInt(level + 1) > 0) {
            return;
        }
        int dmg = event.getGunItemStack().m_41773_() + 1;
        item.m_41721_(dmg);
        livingEntity = event.getShooter();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sv = (ServerPlayer)livingEntity;
            NetworkHandler.sendToClient(new SyncDamageNBTPacket(dmg), sv);
        }
        item.m_41783_().m_128405_("RepairCost", 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void attachmentPropertyEvent(AttachmentPropertyEvent event) {
        GunModifier modifier = DataLookup.getModifiers(event.getGunItem());
        if (modifier == null) {
            return;
        }
        AttachmentCacheProperty cache = event.getCacheProperty();
        ItemStack item = event.getGunItem();
        ResourceLocation gunId = ResourceLocation.parse((String)item.m_41783_().m_128461_("GunId"));
        float durabilityPercent = ((float)item.m_41776_() - (float)item.m_41773_()) / (float)item.m_41776_();
        for (StatModifier mod : modifier.modifiers()) {
            if (durabilityPercent > mod.reductionThreshold()) continue;
            float reductionFactor = Util.remap(durabilityPercent, 0.0f, mod.maxReduction(), mod.reductionThreshold(), 0.0f);
            reductionFactor = Math.max(0.0f, Math.min(reductionFactor, mod.maxReduction()));
            block25: for (GunProperty<?> type : mod.types()) {
                switch (type.name()) {
                    case "pierce": 
                    case "rpm": {
                        GunProperty<?> intType = type;
                        float val = ((Integer)cache.getCache(intType)).intValue();
                        cache.setCache(intType, (Object)Math.round(val * (1.0f - reductionFactor)));
                        continue block25;
                    }
                    case "armor_ignore": 
                    case "ammo_speed": 
                    case "effective_range": 
                    case "head_shot": 
                    case "knockback": 
                    case "weight_modifier": {
                        GunProperty<?> floatType = type;
                        float val = ((Float)cache.getCache(floatType)).floatValue();
                        cache.setCache(floatType, (Object)Float.valueOf(val * (1.0f - reductionFactor)));
                        continue block25;
                    }
                    case "ads": {
                        GunProperty<?> floatType = type;
                        float val = ((Float)cache.getCache(floatType)).floatValue();
                        cache.setCache(floatType, (Object)Float.valueOf(val / (1.0f - reductionFactor)));
                        continue block25;
                    }
                    case "damage": {
                        GunProperty<?> damageType = type;
                        LinkedList val = (LinkedList)cache.getCache(damageType);
                        LinkedList newList = new LinkedList();
                        for (ExtraDamage.DistanceDamagePair pair : val) {
                            newList.add(new ExtraDamage.DistanceDamagePair(pair.getDistance() * (1.0f - reductionFactor), pair.getDamage() * (1.0f - reductionFactor)));
                        }
                        cache.setCache(damageType, (Object)newList);
                        continue block25;
                    }
                    case "inaccuracy": {
                        GunProperty<?> inaccuracyType = type;
                        Map val = (Map)cache.getCache(inaccuracyType);
                        for (Map.Entry entry : val.entrySet()) {
                            entry.setValue(Float.valueOf(((Float)entry.getValue()).floatValue() / (1.0f - reductionFactor)));
                        }
                        cache.setCache(inaccuracyType, (Object)val);
                        continue block25;
                    }
                    case "move_speed": {
                        GunProperty<?> moveSpeedType = type;
                        MoveSpeed val = (MoveSpeed)cache.getCache(moveSpeedType);
                        cache.setCache(moveSpeedType, (Object)new MoveSpeed(val.getBaseMultiplier() * (1.0f - reductionFactor), val.getAimMultiplier() * (1.0f - reductionFactor), val.getReloadMultiplier() * (1.0f - reductionFactor)));
                        continue block25;
                    }
                    case "recoil": {
                        void var20_31;
                        GunData gunData = ((CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).get()).getGunData();
                        GunRecoil recoil = gunData.getRecoil();
                        GunProperty<?> recoilType = type;
                        if (recoil == null) {
                            ParameterizedCachePair parameterizedCachePair = ParameterizedCachePair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                        } else {
                            float pitch = GunDurability.getMaxInGunRecoilKeyFrame(recoil.getPitch());
                            float yaw = GunDurability.getMaxInGunRecoilKeyFrame(recoil.getYaw());
                            ParameterizedCachePair parameterizedCachePair = ParameterizedCachePair.of((Object)Float.valueOf(pitch * (1.0f - reductionFactor)), (Object)Float.valueOf(yaw * (1.0f - reductionFactor)));
                        }
                        cache.setCache(recoilType, (Object)var20_31);
                    }
                }
            }
        }
    }

    public static void anvilChangeEvent(AnvilUpdateEvent event) {
    }

    private static float getMaxInGunRecoilKeyFrame(GunRecoilKeyFrame[] frames) {
        if (frames.length == 0) {
            return 0.0f;
        }
        float[] value = frames[0].getValue();
        float leftValue = Math.abs(value[0]);
        float rightValue = Math.abs(value[1]);
        return Math.max(leftValue, rightValue);
    }

    @Mod.EventBusSubscriber(modid="gundb", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        }
    }
}

