/*
 * Decompiled with CFR 0.152.
 */
package mod.cdv.gdb;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mod.cdv.gdb.resource.GunModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class DataLookup {
    public static final ArrayList<GunModifier> gunModifiers = new ArrayList();
    public static final HashMap<ResourceLocation, GunModifier> modifierCache = new HashMap();

    public static Map<ResourceLocation, GunModifier> getAllModifiersCache() {
        return new HashMap<ResourceLocation, GunModifier>(modifierCache);
    }

    public static ArrayList<GunModifier> getAllModifiers() {
        return new ArrayList<GunModifier>(gunModifiers);
    }

    @Nullable
    public static GunModifier getModifiers(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof ModernKineticGunItem)) {
            return null;
        }
        if (itemStack.m_41783_() == null) {
            return null;
        }
        if (!itemStack.m_41783_().m_128441_("GunId")) {
            return null;
        }
        ResourceLocation gunId = ResourceLocation.parse((String)itemStack.m_41783_().m_128461_("GunId"));
        if (modifierCache.containsKey(gunId)) {
            GunModifier mod = modifierCache.get(gunId);
            if (mod.enabled()) {
                return mod;
            }
            return null;
        }
        Optional index = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId);
        if (index.isEmpty()) {
            return null;
        }
        GunTabType category = GunTabType.valueOf((String)((CommonGunIndex)index.get()).getType().toUpperCase());
        GunModifier modifier = null;
        Optional<GunModifier> gunIdModifier = gunModifiers.stream().filter(gunModifier -> gunModifier.target().right().isPresent() && ((ResourceLocation)gunModifier.target().right().get()).equals((Object)gunId)).findFirst();
        if (gunIdModifier.isPresent()) {
            modifier = gunIdModifier.get();
        } else {
            Optional<GunModifier> categoryModifier = gunModifiers.stream().filter(gunModifier -> gunModifier.target().left().isPresent() && gunModifier.target().left().get() == category).findFirst();
            if (categoryModifier.isPresent()) {
                modifier = categoryModifier.get();
            }
        }
        if (modifier == null) {
            return null;
        }
        modifierCache.put(gunId, modifier);
        if (modifier.enabled()) {
            return modifier;
        }
        return null;
    }

    public static void setModifiers(ArrayList<GunModifier> modifiers) {
        modifierCache.clear();
        gunModifiers.addAll(modifiers);
    }
}

