/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import io.github.mortuusars.chalk.core.component.Point2d;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public enum SymbolOrientation implements StringRepresentable
{
    CENTER(0),
    NORTH(0),
    NORTHEAST(45),
    EAST(90),
    SOUTHEAST(135),
    SOUTH(180),
    SOUTHWEST(225),
    WEST(270),
    NORTHWEST(315);

    private final int rotation;

    private SymbolOrientation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NotNull
    public String m_7912_() {
        return this.name().toLowerCase();
    }

    public SymbolOrientation rotate(Rotation rotation) {
        int step = switch (rotation) {
            case Rotation.CLOCKWISE_90 -> 2;
            case Rotation.CLOCKWISE_180 -> 4;
            case Rotation.COUNTERCLOCKWISE_90 -> 6;
            default -> 0;
        };
        return SymbolOrientation.values()[(this.getRotation() / 45 + step) % 8 + 1];
    }

    public static SymbolOrientation fromRotation(int degrees) {
        for (SymbolOrientation orientation : SymbolOrientation.values()) {
            if (orientation == CENTER || orientation.getRotation() != degrees) continue;
            return orientation;
        }
        return CENTER;
    }

    public static SymbolOrientation fromClickLocationAll(Vec3 clickLocation, Direction face) {
        Point2d coords = SymbolOrientation.getClickedBlockSpaceCoords(clickLocation, face);
        int x = Math.min(2, (int)(coords.x() / 0.333));
        int y = Math.min(2, (int)(coords.y() / 0.333));
        SymbolOrientation[][] rotations = new SymbolOrientation[][]{{NORTHWEST, NORTH, NORTHEAST}, {WEST, CENTER, EAST}, {SOUTHWEST, SOUTH, SOUTHEAST}};
        return rotations[y][x];
    }

    public static SymbolOrientation fromClickLocationCardinal(Vec3 clickLocation, Direction face) {
        Point2d coords = SymbolOrientation.getClickedBlockSpaceCoords(clickLocation, face);
        double x = 0.5 - coords.x();
        double y = 0.5 - coords.y();
        double radians = Math.atan2(y, x);
        double degrees = radians * 57.29577951308232;
        degrees = (degrees + 270.0) % 360.0;
        int region = (int)((degrees + 45.0) % 360.0) / 90;
        return SymbolOrientation.fromRotation(region * 90);
    }

    private static Point2d getClickedBlockSpaceCoords(Vec3 location, Direction face) {
        BlockPos pos = BlockPos.m_274446_((Position)location);
        double x = location.f_82479_ - (double)pos.m_123341_();
        double y = location.f_82480_ - (double)pos.m_123342_();
        double z = location.f_82481_ - (double)pos.m_123343_();
        return switch (face) {
            case Direction.NORTH -> new Point2d(1.0 - x, 1.0 - y);
            case Direction.SOUTH -> new Point2d(x, 1.0 - y);
            case Direction.WEST -> new Point2d(z, 1.0 - y);
            case Direction.EAST -> new Point2d(1.0 - z, 1.0 - y);
            default -> new Point2d(x, z);
        };
    }
}

