/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.puffish.attributesmod.api.DynamicEntityAttribute;
import net.puffish.attributesmod.util.DynamicModificationImpl;
import net.puffish.attributesmod.util.Registrar;
import net.puffish.attributesmod.util.Signed;

public class AttributesMod {
    public static final String MOD_ID = "puffish_attributes";
    public static final ResourceLocation STAMINA_ID = AttributesMod.createIdentifier("stamina");
    public static final Attribute STAMINA = AttributesMod.createClampedAttribute(STAMINA_ID, 4.0, 0.0, 1024.0).m_22084_(true);
    public static final ResourceLocation MAGIC_DAMAGE_ID = AttributesMod.createIdentifier("magic_damage");
    public static final Attribute MAGIC_DAMAGE = DynamicEntityAttribute.create(MAGIC_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation MELEE_DAMAGE_ID = AttributesMod.createIdentifier("melee_damage");
    public static final Attribute MELEE_DAMAGE = DynamicEntityAttribute.create(MELEE_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation RANGED_DAMAGE_ID = AttributesMod.createIdentifier("ranged_damage");
    public static final Attribute RANGED_DAMAGE = DynamicEntityAttribute.create(RANGED_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation TAMED_DAMAGE_ID = AttributesMod.createIdentifier("tamed_damage");
    public static final Attribute TAMED_DAMAGE = DynamicEntityAttribute.create(TAMED_DAMAGE_ID).m_22084_(true);
    public static final ResourceLocation FORTUNE_ID = AttributesMod.createIdentifier("fortune");
    public static final Attribute FORTUNE = DynamicEntityAttribute.create(FORTUNE_ID).m_22084_(true);
    public static final ResourceLocation HEALING_ID = AttributesMod.createIdentifier("healing");
    public static final Attribute HEALING = DynamicEntityAttribute.create(HEALING_ID).m_22084_(true);
    public static final ResourceLocation JUMP_ID = AttributesMod.createIdentifier("jump");
    public static final Attribute JUMP = DynamicEntityAttribute.create(JUMP_ID).m_22084_(true);
    public static final ResourceLocation RESISTANCE_ID = AttributesMod.createIdentifier("resistance");
    public static final Attribute RESISTANCE = DynamicEntityAttribute.create(RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation MAGIC_RESISTANCE_ID = AttributesMod.createIdentifier("magic_resistance");
    public static final Attribute MAGIC_RESISTANCE = DynamicEntityAttribute.create(MAGIC_RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation MELEE_RESISTANCE_ID = AttributesMod.createIdentifier("melee_resistance");
    public static final Attribute MELEE_RESISTANCE = DynamicEntityAttribute.create(MELEE_RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation RANGED_RESISTANCE_ID = AttributesMod.createIdentifier("ranged_resistance");
    public static final Attribute RANGED_RESISTANCE = DynamicEntityAttribute.create(RANGED_RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation TAMED_RESISTANCE_ID = AttributesMod.createIdentifier("tamed_resistance");
    public static final Attribute TAMED_RESISTANCE = DynamicEntityAttribute.create(TAMED_RESISTANCE_ID).m_22084_(true);
    public static final ResourceLocation MINING_SPEED_ID = AttributesMod.createIdentifier("mining_speed");
    public static final Attribute MINING_SPEED = DynamicEntityAttribute.create(MINING_SPEED_ID).m_22084_(true);
    public static final ResourceLocation PICKAXE_SPEED_ID = AttributesMod.createIdentifier("pickaxe_speed");
    public static final Attribute PICKAXE_SPEED = DynamicEntityAttribute.create(PICKAXE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation AXE_SPEED_ID = AttributesMod.createIdentifier("axe_speed");
    public static final Attribute AXE_SPEED = DynamicEntityAttribute.create(AXE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation SHOVEL_SPEED_ID = AttributesMod.createIdentifier("shovel_speed");
    public static final Attribute SHOVEL_SPEED = DynamicEntityAttribute.create(SHOVEL_SPEED_ID).m_22084_(true);
    public static final ResourceLocation SPRINTING_SPEED_ID = AttributesMod.createIdentifier("sprinting_speed");
    public static final Attribute SPRINTING_SPEED = DynamicEntityAttribute.create(SPRINTING_SPEED_ID).m_22084_(true);
    public static final ResourceLocation KNOCKBACK_ID = AttributesMod.createIdentifier("knockback");
    public static final Attribute KNOCKBACK = DynamicEntityAttribute.create(KNOCKBACK_ID).m_22084_(true);
    public static final ResourceLocation REPAIR_COST_ID = AttributesMod.createIdentifier("repair_cost");
    public static final Attribute REPAIR_COST = DynamicEntityAttribute.create(REPAIR_COST_ID).m_22084_(true);
    public static final ResourceLocation ARMOR_SHRED_ID = AttributesMod.createIdentifier("armor_shred");
    public static final Attribute ARMOR_SHRED = DynamicEntityAttribute.create(ARMOR_SHRED_ID).m_22084_(true);
    public static final ResourceLocation TOUGHNESS_SHRED_ID = AttributesMod.createIdentifier("toughness_shred");
    public static final Attribute TOUGHNESS_SHRED = DynamicEntityAttribute.create(TOUGHNESS_SHRED_ID).m_22084_(true);
    public static final ResourceLocation PROTECTION_SHRED_ID = AttributesMod.createIdentifier("protection_shred");
    public static final Attribute PROTECTION_SHRED = DynamicEntityAttribute.create(PROTECTION_SHRED_ID).m_22084_(true);
    public static final ResourceLocation RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("resistance_shred");
    public static final Attribute RESISTANCE_SHRED = DynamicEntityAttribute.create(RESISTANCE_SHRED_ID).m_22084_(true);
    public static final ResourceLocation MAGIC_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("magic_resistance_shred");
    public static final Attribute MAGIC_RESISTANCE_SHRED = DynamicEntityAttribute.create(MAGIC_RESISTANCE_SHRED_ID).m_22084_(true);
    public static final ResourceLocation MELEE_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("melee_resistance_shred");
    public static final Attribute MELEE_RESISTANCE_SHRED = DynamicEntityAttribute.create(MELEE_RESISTANCE_SHRED_ID).m_22084_(true);
    public static final ResourceLocation RANGED_RESISTANCE_SHRED_ID = AttributesMod.createIdentifier("ranged_resistance_shred");
    public static final Attribute RANGED_RESISTANCE_SHRED = DynamicEntityAttribute.create(RANGED_RESISTANCE_SHRED_ID).m_22084_(true);
    public static final ResourceLocation NATURAL_REGENERATION_ID = AttributesMod.createIdentifier("natural_regeneration");
    public static final Attribute NATURAL_REGENERATION = DynamicEntityAttribute.create(NATURAL_REGENERATION_ID).m_22084_(true);
    public static final ResourceLocation STEALTH_ID = AttributesMod.createIdentifier("stealth");
    public static final Attribute STEALTH = DynamicEntityAttribute.create(STEALTH_ID).m_22084_(true);
    public static final ResourceLocation LIFE_STEAL_ID = AttributesMod.createIdentifier("life_steal");
    public static final Attribute LIFE_STEAL = DynamicEntityAttribute.create(LIFE_STEAL_ID).m_22084_(true);
    public static final ResourceLocation FALL_REDUCTION_ID = AttributesMod.createIdentifier("fall_reduction");
    public static final Attribute FALL_REDUCTION = DynamicEntityAttribute.create(FALL_REDUCTION_ID).m_22084_(true);
    public static final ResourceLocation BOW_PROJECTILE_SPEED_ID = AttributesMod.createIdentifier("bow_projectile_speed");
    public static final Attribute BOW_PROJECTILE_SPEED = DynamicEntityAttribute.create(BOW_PROJECTILE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation CROSSBOW_PROJECTILE_SPEED_ID = AttributesMod.createIdentifier("crossbow_projectile_speed");
    public static final Attribute CROSSBOW_PROJECTILE_SPEED = DynamicEntityAttribute.create(CROSSBOW_PROJECTILE_SPEED_ID).m_22084_(true);
    public static final ResourceLocation EXPERIENCE_ID = AttributesMod.createIdentifier("experience");
    public static final Attribute EXPERIENCE = DynamicEntityAttribute.create(EXPERIENCE_ID).m_22084_(true);

    public static void setup(Registrar registrar) {
        AttributesMod.registerAttribute(registrar, STAMINA_ID, STAMINA);
        AttributesMod.registerAttribute(registrar, MAGIC_DAMAGE_ID, MAGIC_DAMAGE);
        AttributesMod.registerAttribute(registrar, MELEE_DAMAGE_ID, MELEE_DAMAGE);
        AttributesMod.registerAttribute(registrar, RANGED_DAMAGE_ID, RANGED_DAMAGE);
        AttributesMod.registerAttribute(registrar, TAMED_DAMAGE_ID, TAMED_DAMAGE);
        AttributesMod.registerAttribute(registrar, FORTUNE_ID, FORTUNE);
        AttributesMod.registerAttribute(registrar, HEALING_ID, HEALING);
        AttributesMod.registerAttribute(registrar, JUMP_ID, JUMP);
        AttributesMod.registerAttribute(registrar, RESISTANCE_ID, RESISTANCE);
        AttributesMod.registerAttribute(registrar, MAGIC_RESISTANCE_ID, MAGIC_RESISTANCE);
        AttributesMod.registerAttribute(registrar, MELEE_RESISTANCE_ID, MELEE_RESISTANCE);
        AttributesMod.registerAttribute(registrar, RANGED_RESISTANCE_ID, RANGED_RESISTANCE);
        AttributesMod.registerAttribute(registrar, TAMED_RESISTANCE_ID, TAMED_RESISTANCE);
        AttributesMod.registerAttribute(registrar, MINING_SPEED_ID, MINING_SPEED);
        AttributesMod.registerAttribute(registrar, PICKAXE_SPEED_ID, PICKAXE_SPEED);
        AttributesMod.registerAttribute(registrar, AXE_SPEED_ID, AXE_SPEED);
        AttributesMod.registerAttribute(registrar, SHOVEL_SPEED_ID, SHOVEL_SPEED);
        AttributesMod.registerAttribute(registrar, SPRINTING_SPEED_ID, SPRINTING_SPEED);
        AttributesMod.registerAttribute(registrar, KNOCKBACK_ID, KNOCKBACK);
        AttributesMod.registerAttribute(registrar, REPAIR_COST_ID, REPAIR_COST);
        AttributesMod.registerAttribute(registrar, ARMOR_SHRED_ID, ARMOR_SHRED);
        AttributesMod.registerAttribute(registrar, TOUGHNESS_SHRED_ID, TOUGHNESS_SHRED);
        AttributesMod.registerAttribute(registrar, PROTECTION_SHRED_ID, PROTECTION_SHRED);
        AttributesMod.registerAttribute(registrar, RESISTANCE_SHRED_ID, RESISTANCE_SHRED);
        AttributesMod.registerAttribute(registrar, MAGIC_RESISTANCE_SHRED_ID, MAGIC_RESISTANCE_SHRED);
        AttributesMod.registerAttribute(registrar, MELEE_RESISTANCE_SHRED_ID, MELEE_RESISTANCE_SHRED);
        AttributesMod.registerAttribute(registrar, RANGED_RESISTANCE_SHRED_ID, RANGED_RESISTANCE_SHRED);
        AttributesMod.registerAttribute(registrar, NATURAL_REGENERATION_ID, NATURAL_REGENERATION);
        AttributesMod.registerAttribute(registrar, STEALTH_ID, STEALTH);
        AttributesMod.registerAttribute(registrar, LIFE_STEAL_ID, LIFE_STEAL);
        AttributesMod.registerAttribute(registrar, FALL_REDUCTION_ID, FALL_REDUCTION);
        AttributesMod.registerAttribute(registrar, BOW_PROJECTILE_SPEED_ID, BOW_PROJECTILE_SPEED);
        AttributesMod.registerAttribute(registrar, CROSSBOW_PROJECTILE_SPEED_ID, CROSSBOW_PROJECTILE_SPEED);
        AttributesMod.registerAttribute(registrar, EXPERIENCE_ID, EXPERIENCE);
    }

    public static ResourceLocation createIdentifier(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static Attribute createClampedAttribute(ResourceLocation id, double fallback, double min, double max) {
        return new RangedAttribute(id.m_214296_("attribute"), fallback, min, max);
    }

    @SafeVarargs
    public static double applyAttributeModifiers(double initial, Signed<AttributeInstance> ... attributes) {
        DynamicModificationImpl dm = new DynamicModificationImpl();
        for (Signed<AttributeInstance> signedAttribute : attributes) {
            dm.with(signedAttribute);
        }
        return dm.applyTo(initial);
    }

    private static void registerAttribute(Registrar registrar, ResourceLocation id, Attribute attribute) {
        registrar.register(BuiltInRegistries.f_256951_, id, attribute);
        registrar.registerAlias(BuiltInRegistries.f_256951_, new ResourceLocation(id.m_135827_(), "player." + id.m_135815_()), id);
    }
}

