/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemFlightAnimator;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public record SyncItemTransfersMessage(Map<Vec3, ItemStack> itemsTransferred, Vec3 playerPos, boolean fromPlayer) {
    public static void encode(SyncItemTransfersMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_236831_(msg.itemsTransferred(), (buf, vec) -> {
            buf.writeDouble(vec.m_7096_());
            buf.writeDouble(vec.m_7098_());
            buf.writeDouble(vec.m_7094_());
        }, FriendlyByteBuf::m_130055_);
        packetBuffer.writeDouble(msg.playerPos.m_7096_());
        packetBuffer.writeDouble(msg.playerPos.m_7098_());
        packetBuffer.writeDouble(msg.playerPos.m_7094_());
        packetBuffer.writeBoolean(msg.fromPlayer);
    }

    public static SyncItemTransfersMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncItemTransfersMessage(packetBuffer.m_236847_(buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), FriendlyByteBuf::m_130267_), new Vec3(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble()), packetBuffer.readBoolean());
    }

    static void onMessage(SyncItemTransfersMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncItemTransfersMessage.handleMessage(msg, context));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleMessage(SyncItemTransfersMessage msg, NetworkEvent.Context context) {
        msg.itemsTransferred().forEach((pos, stack) -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Vec3 from = msg.fromPlayer() ? msg.playerPos : pos;
            Vec3 to = msg.fromPlayer() ? pos : msg.playerPos;
            Level level = player.m_9236_();
            ItemFlightAnimator.startFlight(stack, from, to, level.m_46467_(), msg.fromPlayer() ? 10 : 5, level.m_213780_());
            float pitch = msg.fromPlayer() ? RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f + 0.2f : RandHelper.getRandomMinusOneToOne(level.f_46441_) * 1.4f + 2.0f;
            level.m_6263_((Player)player, to.m_7096_(), to.m_7098_(), to.m_7094_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.3f, pitch);
        });
    }
}

