/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.packets;

import com.google.gson.Gson;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncConfigDataPacket {
    private final String chunkData;
    private final int chunkIndex;
    private final int totalChunks;
    private final String sessionId;
    private static final Gson GSON = new Gson();
    private static final int MAX_CHUNK_SIZE = 30000;

    public SyncConfigDataPacket(String chunkData, int chunkIndex, int totalChunks, String sessionId) {
        this.chunkData = chunkData;
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.sessionId = sessionId;
    }

    public static SyncConfigDataPacket[] createChunkedPackets(Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> configData) {
        String fullJson = GSON.toJson(configData);
        String sessionId = String.valueOf(System.currentTimeMillis());
        if (fullJson.length() <= 30000) {
            return new SyncConfigDataPacket[]{new SyncConfigDataPacket(fullJson, 0, 1, sessionId)};
        }
        int totalChunks = (int)Math.ceil((double)fullJson.length() / 30000.0);
        SyncConfigDataPacket[] packets = new SyncConfigDataPacket[totalChunks];
        for (int i = 0; i < totalChunks; ++i) {
            int startIndex = i * 30000;
            int endIndex = Math.min(startIndex + 30000, fullJson.length());
            String chunk = fullJson.substring(startIndex, endIndex);
            packets[i] = new SyncConfigDataPacket(chunk, i, totalChunks, sessionId);
        }
        return packets;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.chunkData);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130070_(this.sessionId);
    }

    public static SyncConfigDataPacket decode(FriendlyByteBuf buf) {
        return new SyncConfigDataPacket(buf.m_130277_(), buf.readInt(), buf.readInt(), buf.m_130277_());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ScrapperDataManager.handleConfigChunk(this.chunkData, this.chunkIndex, this.totalChunks, this.sessionId);
            }
        });
        context.setPacketHandled(true);
    }
}

