/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.packets;

import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import com.keerdm.item_scrapper.blocks.ScrapperEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ScrapperInsertItemPacket {
    private final BlockPos blockPos;
    private final ItemStack itemStack;

    public ScrapperInsertItemPacket(BlockPos pos, ItemStack stack) {
        this.blockPos = pos;
        this.itemStack = stack;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_130055_(this.itemStack);
    }

    public static ScrapperInsertItemPacket decode(FriendlyByteBuf buf) {
        return new ScrapperInsertItemPacket(buf.m_130135_(), buf.m_130267_());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(this.blockPos)) instanceof ScrapperBlockEntity) {
                ScrapperBlockEntity scrapperBlockEntity = (ScrapperBlockEntity)blockEntity;
                ItemStack playerStack = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
                if (!playerStack.m_41619_()) {
                    ItemStack singleItem = playerStack.m_41777_();
                    singleItem.m_41764_(1);
                    ItemStack remainingItem = scrapperBlockEntity.getInputItemHandler().insertItem(0, singleItem, false);
                    if (remainingItem.m_41619_()) {
                        playerStack.m_41774_(1);
                        if (playerStack.m_41619_()) {
                            player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
                        }
                        ScrapperEffects.playItemPlaceSound(player.m_9236_(), this.blockPos, player.m_9236_().m_8055_(this.blockPos));
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

