/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.packets;

import com.keerdm.item_scrapper.blocks.ScrapperBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ScrapItemPacket {
    private final BlockPos pos;
    private final float attackStrength;

    public ScrapItemPacket(BlockPos pos, float attackStrength) {
        this.pos = pos;
        this.attackStrength = attackStrength;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeFloat(this.attackStrength);
    }

    public static ScrapItemPacket decode(FriendlyByteBuf buf) {
        return new ScrapItemPacket(buf.m_130135_(), buf.readFloat());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level;
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(this.pos)) instanceof ScrapperBlockEntity) {
                ScrapperBlockEntity scrapperBlockEntity = (ScrapperBlockEntity)blockEntity;
                float attackStrength = player.m_36403_(0.0f);
                if (attackStrength >= 0.2f) {
                    scrapperBlockEntity.addHit(attackStrength, (Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

