/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.integration.jei.recipe;

import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ScrapperJEIRecipe {
    private final ItemStack input;
    private final List<ItemStack> outputs;
    private final double requiredHits;
    private final Scrapper_conversionsConfig.ReturnAmount returnAmount;
    private final double explosionChance;
    private final boolean usesDurabilityMultiplier;
    private final String sourceInfo;

    public ScrapperJEIRecipe(ItemStack input, List<ItemStack> outputs, double requiredHits, Scrapper_conversionsConfig.ReturnAmount returnAmount, double explosionChance, boolean usesDurabilityMultiplier, String sourceInfo) {
        this.input = input;
        this.outputs = outputs;
        this.requiredHits = requiredHits;
        this.returnAmount = returnAmount;
        this.explosionChance = explosionChance;
        this.usesDurabilityMultiplier = usesDurabilityMultiplier;
        this.sourceInfo = sourceInfo;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public double getRequiredHits() {
        return this.requiredHits;
    }

    public Scrapper_conversionsConfig.ReturnAmount getReturnAmount() {
        return this.returnAmount;
    }

    public double getExplosionChance() {
        return this.explosionChance;
    }

    public boolean usesDurabilityMultiplier() {
        return this.usesDurabilityMultiplier;
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public boolean isRecipeBased() {
        return this.returnAmount != null;
    }

    public String getSourceDisplayName() {
        if (this.isRecipeBased()) {
            return "Recipe: " + this.sourceInfo;
        }
        return "Loot Table: " + this.sourceInfo;
    }
}

