/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.integration.jei.category;

import com.keerdm.item_scrapper.ItemScrapper;
import com.keerdm.item_scrapper.integration.jei.ItemScrapperJEIPlugin;
import com.keerdm.item_scrapper.integration.jei.recipe.ScrapperJEIRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ScrapperRecipeCategory
implements IRecipeCategory<ScrapperJEIRecipe> {
    private static final int RECIPE_WIDTH = 170;
    private static final int RECIPE_HEIGHT = 140;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable arrow;
    private final Component title;

    public ScrapperRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(170, 140);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ItemScrapper.SCRAPPER_BLOCK.get()));
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = Internal.getTextures().getRecipeArrow();
        this.title = Component.m_237115_((String)"jei.item_scrapper.scrapping");
    }

    public RecipeType<ScrapperJEIRecipe> getRecipeType() {
        return ItemScrapperJEIPlugin.SCRAPPER_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ScrapperJEIRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 20).addItemStack(recipe.getInput())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 10, 50).addItemStack(new ItemStack((ItemLike)ItemScrapper.SCRAPPING_HAMMER.get()))).setBackground(this.slot, -1, -1);
        int outputIndex = 0;
        int maxOutputsToShow = Math.min(recipe.getOutputs().size(), 12);
        for (int row = 0; row < 4 && outputIndex < maxOutputsToShow; ++row) {
            for (int col = 0; col < 3 && outputIndex < maxOutputsToShow; ++outputIndex, ++col) {
                int x = 90 + col * 20;
                int y = 10 + row * 20;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(recipe.getOutputs().get(outputIndex))).setBackground(this.slot, -1, -1);
            }
        }
    }

    public void draw(ScrapperJEIRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        int textColor = 0x404040;
        int warningColor = 0xCC4040;
        int specialColor = 0x606020;
        this.arrow.draw(guiGraphics, 50, 32);
        int leftMargin = 10;
        int yPos = 85;
        int lineHeight = 10;
        String hitsText = String.format("Hits: %.1f", recipe.getRequiredHits());
        guiGraphics.m_280056_(minecraft.f_91062_, hitsText, leftMargin, yPos, textColor, false);
        yPos += lineHeight;
        if (recipe.getReturnAmount() != null) {
            String returnText = String.format("Return: %.0f-%.0f%%", recipe.getReturnAmount().min, recipe.getReturnAmount().max);
            guiGraphics.m_280056_(minecraft.f_91062_, returnText, leftMargin, yPos, textColor, false);
            yPos += lineHeight;
        }
        if (recipe.getExplosionChance() > 0.0) {
            String explosionText = String.format("Explosion: %.1f%%", recipe.getExplosionChance());
            guiGraphics.m_280056_(minecraft.f_91062_, explosionText, leftMargin, yPos, warningColor, false);
            yPos += lineHeight;
        }
        if (recipe.usesDurabilityMultiplier() && recipe.getInput().m_41763_()) {
            String durabilityText = "Durability affects output";
            guiGraphics.m_280056_(minecraft.f_91062_, durabilityText, leftMargin, yPos, specialColor, false);
            yPos += lineHeight;
        }
        if (recipe.getOutputs().size() > 12) {
            String moreText = String.format("... +%d more items", recipe.getOutputs().size() - 12);
            int moreX = (170 - minecraft.f_91062_.m_92895_(moreText)) / 2;
            int moreY = 125;
            guiGraphics.m_280056_(minecraft.f_91062_, moreText, moreX, moreY, specialColor, false);
        }
    }
}

