/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.integration.jei;

import com.google.gson.Gson;
import com.keerdm.item_scrapper.ItemScrapper;
import com.keerdm.item_scrapper.blocks.TACZCustomRecipeLoader;
import com.keerdm.item_scrapper.configs.CommonConfig;
import com.keerdm.item_scrapper.configs.RoundingType;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.integration.PointBlankHelper;
import com.keerdm.item_scrapper.integration.jei.category.ScrapperRecipeCategory;
import com.keerdm.item_scrapper.integration.jei.recipe.ScrapperJEIRecipe;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ItemScrapperJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = new ResourceLocation("item_scrapper", "jei_plugin");
    public static final RecipeType<ScrapperJEIRecipe> SCRAPPER_RECIPE_TYPE = RecipeType.create((String)"item_scrapper", (String)"scrapping", ScrapperJEIRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ScrapperRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<ScrapperJEIRecipe> scrapperRecipes = this.createScrapperRecipes();
        registration.addRecipes(SCRAPPER_RECIPE_TYPE, scrapperRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemScrapper.SCRAPPER_BLOCK.get()), new RecipeType[]{SCRAPPER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemScrapper.SCRAPPING_HAMMER.get()), new RecipeType[]{SCRAPPER_RECIPE_TYPE});
    }

    private List<ScrapperJEIRecipe> createScrapperRecipes() {
        ArrayList<ScrapperJEIRecipe> recipes = new ArrayList<ScrapperJEIRecipe>();
        Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> allConfigs = ScrapperDataManager.getAllConfigs();
        for (Map.Entry<String, List<Scrapper_conversionsConfig.ScrapConfig>> entry : allConfigs.entrySet()) {
            String itemId = entry.getKey();
            List<Scrapper_conversionsConfig.ScrapConfig> configs = entry.getValue();
            try {
                ResourceLocation itemResource = new ResourceLocation(itemId);
                Optional itemOptional = BuiltInRegistries.f_257033_.m_6612_(itemResource);
                if (!itemOptional.isPresent() || ((Item)itemOptional.get()).equals(Items.f_41852_)) continue;
                for (Scrapper_conversionsConfig.ScrapConfig config : configs) {
                    ScrapperJEIRecipe recipe = this.createRecipeFromConfig((Item)itemOptional.get(), config);
                    if (recipe == null) continue;
                    recipes.add(recipe);
                }
            }
            catch (Exception e) {
                System.err.println("Error creating JEI recipe for item: " + itemId + " - " + e.getMessage());
            }
        }
        return recipes;
    }

    private ScrapperJEIRecipe createRecipeFromConfig(Item item, Scrapper_conversionsConfig.ScrapConfig config) {
        try {
            ItemStack input = new ItemStack((ItemLike)item);
            if (config.requiredNbt != null && !config.requiredNbt.isEmpty()) {
                try {
                    input.m_41784_().m_128391_(TagParser.m_129359_((String)config.requiredNbt));
                }
                catch (Exception e) {
                    System.err.println("Error applying NBT to JEI recipe: " + e.getMessage());
                }
            }
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            if (config.lootable.isAutoGenerateFromRecipe()) {
                outputs = this.resolveActualRecipeIngredients(config);
            } else {
                outputs.add(this.createLootTableRepresentation(config.lootable.getLootTable()));
            }
            return new ScrapperJEIRecipe(input, outputs, config.requiredHits, config.lootable.getReturnAmount(), config.explosionChance, config.useDurabilityMultiplier, config.lootable.isAutoGenerateFromRecipe() ? String.join((CharSequence)", ", config.lootable.getRecipeIds()) : config.lootable.getLootTable());
        }
        catch (Exception e) {
            System.err.println("Error creating JEI recipe: " + e.getMessage());
            return null;
        }
    }

    private List<ItemStack> resolveActualRecipeIngredients(Scrapper_conversionsConfig.ScrapConfig config) {
        HashMap<Item, Integer> totalIngredients = new HashMap<Item, Integer>();
        if (Minecraft.m_91087_().f_91073_ == null) {
            return this.createFallbackOutputs();
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        for (String recipeId : config.lootable.getRecipeIds()) {
            try {
                ResourceLocation recipeLocation = new ResourceLocation(recipeId);
                Optional recipeOptional = recipeManager.m_44043_(recipeLocation);
                if (recipeOptional.isPresent()) {
                    ItemStack recipeResult;
                    HashMap<Item, Integer> recipeIngredients;
                    Recipe recipe = (Recipe)recipeOptional.get();
                    boolean recipeProcessed = false;
                    if (recipe.m_6671_().toString().equals("pointblank:default") || recipe.m_6671_().toString().equals("default")) {
                        try {
                            boolean processed;
                            recipeIngredients = new HashMap<Item, Integer>();
                            boolean bl = processed = PointBlankHelper.isPointBlankLoaded() && recipe.getClass().getName().contains("pointblank") && PointBlankHelper.processPointBlankRecipe(recipe, recipeIngredients);
                            if (processed) {
                                recipeIngredients.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                                recipeProcessed = true;
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Error processing PointBlank recipe in JEI: " + e.getMessage());
                        }
                    }
                    if (!recipeProcessed && recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        HashMap<Item, Integer> recipeIngredients2 = new HashMap<Item, Integer>();
                        NonNullList ingredients = craftingRecipe.m_7527_();
                        this.collectIngredientsFromList((NonNullList<Ingredient>)ingredients, recipeIngredients2);
                        recipeIngredients2.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                        recipeProcessed = true;
                    }
                    if (!recipeProcessed) {
                        recipeIngredients = new HashMap();
                        this.tryReflectionIngredients(recipe, recipeIngredients);
                        recipeIngredients.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
                        recipeProcessed = true;
                    }
                    if (recipeProcessed || (recipeResult = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())).m_41619_()) continue;
                    totalIngredients.merge(recipeResult.m_41720_(), recipeResult.m_41613_(), Integer::sum);
                    continue;
                }
                this.tryLoadCustomRecipe(recipeLocation, config, totalIngredients);
            }
            catch (Exception e) {
                System.err.println("Error resolving recipe ingredients for: " + recipeId + " - " + e.getMessage());
            }
        }
        return this.processIngredientsToItemStacks(totalIngredients, config);
    }

    private void collectIngredientsFromList(NonNullList<Ingredient> ingredients, Map<Item, Integer> totalIngredients) {
        for (Ingredient ingredient : ingredients) {
            ItemStack[] matchingStacks = ingredient.m_43908_();
            if (matchingStacks.length <= 0) continue;
            Item item = matchingStacks[0].m_41720_();
            totalIngredients.merge(item, 1, Integer::sum);
        }
    }

    private void tryReflectionIngredients(Recipe<?> recipe, Map<Item, Integer> totalIngredients) {
        try {
            Method getIngredientsMethod = recipe.getClass().getMethod("getIngredients", new Class[0]);
            Object ingredientsList = getIngredientsMethod.invoke(recipe, new Object[0]);
            if (ingredientsList instanceof NonNullList) {
                NonNullList ingredients = (NonNullList)ingredientsList;
                this.collectIngredientsFromList((NonNullList<Ingredient>)ingredients, totalIngredients);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tryLoadCustomRecipe(ResourceLocation recipeId, Scrapper_conversionsConfig.ScrapConfig config, Map<Item, Integer> totalIngredients) {
        try {
            ArrayList<Path> basePaths = new ArrayList<Path>();
            if (((Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get()).booleanValue()) {
                basePaths.add(Paths.get("tacz", new String[0]));
            }
            basePaths.add(Paths.get("config/tacz/custom", new String[0]));
            for (Path basePath : basePaths) {
                if (!Files.exists(basePath, new LinkOption[0])) continue;
                Stream<Path> modDirs = Files.list(basePath);
                try {
                    modDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(modDir -> {
                        String namespace;
                        String modDirName = modDir.getFileName().toString();
                        if (modDirName.startsWith(namespace = recipeId.m_135827_())) {
                            try {
                                Path recipesDir;
                                Path namespacePath = (Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get() != false && basePath.endsWith("tacz") ? modDir.resolve("data").resolve(namespace) : modDir.resolve(namespace);
                                if (Files.exists(namespacePath, new LinkOption[0]) && Files.exists(recipesDir = namespacePath.resolve("recipes"), new LinkOption[0])) {
                                    String[] subDirs;
                                    for (String dir : subDirs = new String[]{"ammo", "attachments", "gun"}) {
                                        Path recipePath = recipesDir.resolve(dir).resolve(recipeId.m_135815_() + ".json");
                                        if (!Files.exists(recipePath, new LinkOption[0])) continue;
                                        this.processCustomRecipeFile(recipePath, totalIngredients);
                                        return;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    if (modDirs == null) continue;
                    modDirs.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processCustomRecipeFile(Path recipePath, Map<Item, Integer> totalIngredients) {
        try {
            String recipeJson = Files.readString(recipePath);
            Gson gson = new Gson();
            TACZCustomRecipeLoader customRecipe = (TACZCustomRecipeLoader)gson.fromJson(recipeJson, TACZCustomRecipeLoader.class);
            if (Minecraft.m_91087_().f_91073_ != null) {
                Map<Item, Integer> customIngredients = customRecipe.getIngredients(Minecraft.m_91087_().f_91073_.m_9598_());
                customIngredients.forEach((item, count) -> totalIngredients.merge((Item)item, (Integer)count, Integer::sum));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<ItemStack> processIngredientsToItemStacks(Map<Item, Integer> totalIngredients, Scrapper_conversionsConfig.ScrapConfig config) {
        List<ItemStack> results = new ArrayList();
        if (totalIngredients.isEmpty()) {
            return this.createFallbackOutputs();
        }
        double avgReturnPercent = (config.lootable.getReturnAmount().min + config.lootable.getReturnAmount().max) / 2.0;
        for (Map.Entry<Item, Integer> entry : totalIngredients.entrySet()) {
            int totalCount = entry.getValue();
            double exactCount = (double)totalCount * (avgReturnPercent / 100.0);
            int returnCount = switch (config.roundingType) {
                case RoundingType.FLOOR -> (int)Math.floor(exactCount);
                case RoundingType.CEILING -> (int)Math.ceil(exactCount);
                default -> (int)Math.round(exactCount);
            };
            if (returnCount <= 0) continue;
            ItemStack resultStack = new ItemStack((ItemLike)entry.getKey(), returnCount);
            results.add(resultStack);
        }
        if (results.size() > 15) {
            results = results.subList(0, 15);
            ItemStack moreItems = new ItemStack((ItemLike)Items.f_151058_);
            moreItems.m_41714_((Component)Component.m_237113_((String)"... and more"));
            results.add(moreItems);
        }
        return results.isEmpty() ? this.createFallbackOutputs() : results;
    }

    private ItemStack createLootTableRepresentation(String lootTable) {
        ItemStack representation = lootTable.contains("treasure") || lootTable.contains("chest") ? new ItemStack((ItemLike)Items.f_42009_) : (lootTable.contains("ore") || lootTable.contains("mining") ? new ItemStack((ItemLike)Items.f_42385_) : new ItemStack((ItemLike)Items.f_151058_));
        representation.m_41714_((Component)Component.m_237113_((String)("Loot from: " + lootTable)));
        return representation;
    }

    private List<ItemStack> createFallbackOutputs() {
        ArrayList<ItemStack> fallback = new ArrayList<ItemStack>();
        ItemStack unknown = new ItemStack((ItemLike)Items.f_42127_);
        unknown.m_41714_((Component)Component.m_237113_((String)"Output varies - check in-game"));
        fallback.add(unknown);
        return fallback;
    }
}

