/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.integration;

import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PointBlankHelper {
    private static Boolean isPointBlankLoaded = null;

    public static boolean isPointBlankLoaded() {
        if (isPointBlankLoaded == null) {
            try {
                Class.forName("com.vicmatskiv.pointblank.crafting.PointBlankIngredient");
                isPointBlankLoaded = true;
            }
            catch (ClassNotFoundException e) {
                isPointBlankLoaded = false;
            }
        }
        return isPointBlankLoaded;
    }

    public static boolean processPointBlankRecipe(Object recipe, Map<Item, Integer> totalIngredients) {
        if (!PointBlankHelper.isPointBlankLoaded()) {
            return false;
        }
        try {
            Field ingredientsField = recipe.getClass().getDeclaredField("ingredients");
            ingredientsField.setAccessible(true);
            Object ingredients = ingredientsField.get(recipe);
            if (ingredients instanceof List) {
                List ingredientsList = (List)ingredients;
                for (Object obj : ingredientsList) {
                    if (obj == null || !obj.getClass().getName().contains("PointBlankIngredient")) continue;
                    List itemStacks = (List)obj.getClass().getMethod("getItemStacks", new Class[0]).invoke(obj, new Object[0]);
                    int count = (Integer)obj.getClass().getMethod("getCount", new Class[0]).invoke(obj, new Object[0]);
                    if (itemStacks.isEmpty()) continue;
                    ItemStack firstStack = (ItemStack)itemStacks.get(0);
                    totalIngredients.merge(firstStack.m_41720_(), count, Integer::sum);
                }
                return true;
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("PointBlank recipe processing failed: " + e.getMessage());
        }
        return false;
    }
}

