/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.events;

import com.keerdm.item_scrapper.configs.ClientConfig;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="item_scrapper", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ScrapperTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return;
        }
        Scrapper_conversionsConfig.ScrapConfig config = ScrapperDataManager.getConfigForItem(itemId.toString(), stack.m_41783_());
        if (config != null) {
            Scrapper_conversionsConfig.ReturnAmount returnAmount;
            if (((Boolean)ClientConfig.SHOW_SCRAPPABLE_INDICATOR.get()).booleanValue()) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.item_scrapper.scrappable").m_130940_(ChatFormatting.GREEN));
            }
            if (((Boolean)ClientConfig.SHOW_REQUIRED_HITS.get()).booleanValue()) {
                event.getToolTip().add(Component.m_237110_((String)"tooltip.item_scrapper.required_hits", (Object[])new Object[]{String.format("%.1f", config.requiredHits)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (((Boolean)ClientConfig.SHOW_EXPLOSION_CHANCE.get()).booleanValue() && config.explosionChance > 0.0) {
                event.getToolTip().add(Component.m_237110_((String)"tooltip.item_scrapper.explosion_chance", (Object[])new Object[]{String.format("%.1f", config.explosionChance)}).m_130940_(ChatFormatting.RED));
            }
            if (((Boolean)ClientConfig.SHOW_DURABILITY_INFO.get()).booleanValue() && config.useDurabilityMultiplier) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.item_scrapper.durability_multiplier").m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (((Boolean)ClientConfig.SHOW_RETURN_AMOUNT.get()).booleanValue() && config.lootable.isAutoGenerateFromRecipe() && (returnAmount = config.lootable.getReturnAmount()) != null) {
                event.getToolTip().add(Component.m_237110_((String)"tooltip.item_scrapper.return_amount", (Object[])new Object[]{String.format("%.1f", returnAmount.min), String.format("%.1f", returnAmount.max)}).m_130940_(ChatFormatting.GOLD));
            }
        }
    }
}

