/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.events;

import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.data.TransformDataManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="item_scrapper", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigWarningSystem {
    private static boolean hasWarned = false;
    private static boolean configsDetected = false;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.getServer() == null) {
            return;
        }
        ConfigWarningSystem.checkAndWarnNoConfigs(event.getServer());
    }

    private static void checkAndWarnNoConfigs(MinecraftServer server) {
        boolean currentConfigsDetected;
        boolean hasScrapperConfigs = !ScrapperDataManager.getAllConfigs().isEmpty();
        boolean hasTransformConfigs = !TransformDataManager.getAllTransforms().isEmpty();
        boolean bl = currentConfigsDetected = hasScrapperConfigs || hasTransformConfigs;
        if (!currentConfigsDetected && !hasWarned) {
            MutableComponent warningMessage = Component.m_237113_((String)"\u26a0 No Item Scrapper content config pack detected! \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            MutableComponent subMessage = Component.m_237113_((String)"Please ensure you have installed a compatible datapack or mod with Item Scrapper configurations.").m_130940_(ChatFormatting.YELLOW);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.m_213846_((Component)warningMessage);
                player.m_213846_((Component)subMessage);
            }
            System.out.println("[ItemScrapper Warning] No content config pack detected.");
            hasWarned = true;
        } else if (!configsDetected && currentConfigsDetected) {
            System.out.println("[ItemScrapper] Content configs detected and loaded successfully.");
        }
        configsDetected = currentConfigsDetected;
    }

    public static void resetWarningState() {
        hasWarned = false;
        configsDetected = false;
    }
}

