/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.events;

import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="item_scrapper", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigSyncHandler {
    private static final Map<ServerPlayer, Integer> pendingSyncs = new WeakHashMap<ServerPlayer, Integer>();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemScrapperLogger.debugLog("SERVER: Player " + player.m_7755_().getString() + " joined, scheduling config sync");
            pendingSyncs.put(player, 40);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<ServerPlayer, Integer>> iterator = pendingSyncs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = iterator.next();
            ServerPlayer player = entry.getKey();
            if (player == null) {
                iterator.remove();
                continue;
            }
            int remaining = entry.getValue() - 1;
            if (remaining <= 0) {
                ItemScrapperLogger.debugLog("SERVER: Syncing configs to " + player.m_7755_().getString());
                ScrapperDataManager.syncToPlayer(player);
                iterator.remove();
                continue;
            }
            entry.setValue(remaining);
        }
    }
}

