/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.effects;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CustomExplosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final Random random;
    private static final float SHOCK_WAVE_VELOCITY = 3.5f;
    private static final float BLAST_WIND_VELOCITY = 2.8f;
    private static final float SUCTION_VELOCITY = 1.2f;
    private static final float FIREBALL_RISE_SPEED = 0.15f;
    private static final int MAX_BLOCKS_PER_TICK = 400;
    private static final int MAX_DEBRIS_PER_TICK = 150;
    private static final int FIREBALL_PEAK_TEMP = 3000;
    private static final int FIREBALL_MIN_TEMP = 800;
    private final int shockRadius;
    private final int blastRadius;
    private final int fireballRadius;
    private final int debrisRadius;
    private static final Map<Level, ExplosionProcessor> activeExplosions = new HashMap<Level, ExplosionProcessor>();

    public CustomExplosion(Level level, double x, double y, double z, float power) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        this.random = new Random();
        this.shockRadius = (int)(power * 1.2f);
        this.blastRadius = (int)(power * 1.5f);
        this.fireballRadius = (int)(power * 0.8f);
        this.debrisRadius = (int)(power * 2.0f);
    }

    public void explode() {
        if (this.level.f_46443_) {
            return;
        }
        ExplosionProcessor processor = activeExplosions.computeIfAbsent(this.level, l -> new ExplosionProcessor((Level)l));
        processor.queueExplosion(this);
    }

    private float getAdvancedNoise(float x, float y, float z) {
        float scale1 = 0.1f;
        float scale2 = 0.05f;
        float scale3 = 0.2f;
        float noise1 = (float)(Math.sin(x * scale1) * Math.cos(y * scale1) * Math.sin(z * scale1));
        float noise2 = (float)(Math.cos(x * scale2 + y * scale2) * Math.sin(z * scale2));
        float noise3 = (float)(Math.sin(x * scale3) * Math.cos(z * scale3));
        float combined = noise1 * 0.5f + noise2 * 0.3f + noise3 * 0.2f;
        return (combined += (this.random.nextFloat() - 0.5f) * 0.4f) * 2.5f;
    }

    public static void createExplosion(Level level, Vec3 position, float power) {
        CustomExplosion explosion = new CustomExplosion(level, position.f_82479_, position.f_82480_, position.f_82481_, power);
        explosion.explode();
    }

    private static class ExplosionProcessor {
        private final Level level;
        private final Queue<ExplosionTask> tasks = new ConcurrentLinkedQueue<ExplosionTask>();
        private boolean scheduled = false;

        ExplosionProcessor(Level level) {
            this.level = level;
        }

        void queueExplosion(CustomExplosion explosion) {
            Level level;
            this.tasks.add(new ExplosionTask(explosion));
            if (!this.scheduled && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.scheduled = true;
                this.scheduleNextTick(serverLevel);
            }
        }

        private void scheduleNextTick(ServerLevel serverLevel) {
            serverLevel.m_7654_().execute(() -> {
                this.processTick();
                if (!this.tasks.isEmpty()) {
                    serverLevel.m_7654_().execute(() -> this.scheduleNextTick(serverLevel));
                } else {
                    this.scheduled = false;
                    activeExplosions.remove(this.level);
                }
            });
        }

        private void processTick() {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                ExplosionTask task = (ExplosionTask)iterator.next();
                task.processNextPhase();
                if (!task.isComplete()) continue;
                iterator.remove();
            }
        }
    }

    private static class ExplosionTask {
        private final CustomExplosion explosion;
        private ExplosionPhase currentPhase = ExplosionPhase.FIREBALL_FORMATION;
        private int tickCounter = 0;
        private final List<BlockData> shockBlocks = new ArrayList<BlockData>();
        private final List<BlockData> blastBlocks = new ArrayList<BlockData>();
        private final List<DebrisData> debrisObjects = new ArrayList<DebrisData>();
        private final List<BlockPos> fireballBlocks = new ArrayList<BlockPos>();
        private float currentShockRadius = 0.0f;
        private float currentBlastRadius = 0.0f;
        private float currentSuctionRadius = 0.0f;
        private float fireballHeight = 0.0f;
        private int fireballTemperature = 3000;
        private int shockIndex = 0;
        private int blastIndex = 0;
        private int debrisIndex = 0;
        private int suctionIndex = 0;

        ExplosionTask(CustomExplosion explosion) {
            this.explosion = explosion;
            this.calculateExplosionData();
        }

        private void calculateExplosionData() {
            int px = (int)(this.explosion.x - (double)this.explosion.debrisRadius);
            while ((double)px <= this.explosion.x + (double)this.explosion.debrisRadius) {
                int py = (int)(this.explosion.y - (double)this.explosion.debrisRadius);
                while ((double)py <= this.explosion.y + (double)this.explosion.debrisRadius) {
                    int pz = (int)(this.explosion.z - (double)this.explosion.debrisRadius);
                    while ((double)pz <= this.explosion.z + (double)this.explosion.debrisRadius) {
                        BlockPos pos = new BlockPos(px, py, pz);
                        float distance = (float)Math.sqrt(Math.pow((double)px - this.explosion.x, 2.0) + Math.pow((double)py - this.explosion.y, 2.0) + Math.pow((double)pz - this.explosion.z, 2.0));
                        BlockState state = this.explosion.level.m_8055_(pos);
                        if (!state.m_60795_()) {
                            float noise;
                            float effectiveDistance;
                            boolean amplified = this.checkReflectionAmplification(pos);
                            float f = effectiveDistance = amplified ? distance * 0.4f : distance;
                            if (distance <= (float)this.explosion.fireballRadius * 0.3f) {
                                this.fireballBlocks.add(pos);
                            } else if (effectiveDistance <= (float)this.explosion.shockRadius) {
                                noise = this.explosion.getAdvancedNoise(px, py, pz);
                                if (distance - noise <= (float)this.explosion.shockRadius) {
                                    this.shockBlocks.add(new BlockData(pos, distance, state, amplified));
                                }
                            } else if (effectiveDistance <= (float)this.explosion.blastRadius && distance - (noise = this.explosion.getAdvancedNoise(px, py, pz)) <= (float)this.explosion.blastRadius) {
                                this.blastBlocks.add(new BlockData(pos, distance, state, amplified));
                            }
                            if (distance <= (float)this.explosion.debrisRadius && !state.m_60795_() && this.explosion.random.nextFloat() < this.calculateDebrisChance(distance, state)) {
                                this.createDebrisObject(pos, distance, state);
                            }
                        }
                        ++pz;
                    }
                    ++py;
                }
                ++px;
            }
            this.shockBlocks.sort(Comparator.comparing(b -> Float.valueOf(b.distance)));
            this.blastBlocks.sort(Comparator.comparing(b -> Float.valueOf(b.distance)));
        }

        private boolean checkReflectionAmplification(BlockPos pos) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos checkPos;
                        BlockState state;
                        if (dx == 0 && dy == 0 && dz == 0 || (state = this.explosion.level.m_8055_(checkPos = pos.m_7918_(dx, dy, dz))).m_60795_() || !(state.m_60800_((BlockGetter)this.explosion.level, checkPos) > 10.0f)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private float calculateDebrisChance(float distance, BlockState state) {
            float baseChance = 0.8f - distance / (float)this.explosion.debrisRadius * 0.6f;
            float hardness = state.m_60800_((BlockGetter)this.explosion.level, BlockPos.f_121853_);
            if (hardness < 0.0f) {
                return 0.0f;
            }
            if (hardness > 5.0f) {
                baseChance *= 0.7f;
            }
            if (hardness < 1.0f) {
                baseChance *= 1.3f;
            }
            return Math.max(0.0f, Math.min(1.0f, baseChance));
        }

        private void createDebrisObject(BlockPos pos, float distance, BlockState state) {
            float power = Math.max(0.1f, 1.0f - distance / (float)this.explosion.debrisRadius);
            float velocityMagnitude = power * (3.0f + this.explosion.random.nextFloat() * 2.0f);
            Vec3 direction = new Vec3((double)pos.m_123341_() - this.explosion.x + (double)((this.explosion.random.nextFloat() - 0.5f) * 2.0f), (double)pos.m_123342_() - this.explosion.y + (double)((this.explosion.random.nextFloat() - 0.5f) * 2.0f) + 0.5, (double)pos.m_123343_() - this.explosion.z + (double)((this.explosion.random.nextFloat() - 0.5f) * 2.0f)).m_82541_();
            Vec3 velocity = direction.m_82490_((double)velocityMagnitude);
            boolean isHeavy = state.m_60800_((BlockGetter)this.explosion.level, pos) > 3.0f;
            this.debrisObjects.add(new DebrisData(pos, velocity, state, isHeavy));
        }

        void processNextPhase() {
            ++this.tickCounter;
            switch (this.currentPhase) {
                case FIREBALL_FORMATION: {
                    this.processFireballFormation();
                    break;
                }
                case SHOCK_WAVE: {
                    this.processShockWave();
                    break;
                }
                case BLAST_WIND: {
                    this.processBlastWind();
                    break;
                }
                case DEBRIS_EJECTION: {
                    this.processDebrisEjection();
                    break;
                }
                case NEGATIVE_PHASE: {
                    this.processNegativePhase();
                    break;
                }
                case FIREBALL_RISE: {
                    this.processFireballRise();
                    break;
                }
                case SECONDARY_FIRES: {
                    this.processSecondaryFires();
                }
            }
        }

        private void processFireballFormation() {
            if (this.tickCounter <= 2) {
                int processed = 0;
                for (BlockPos pos : this.fireballBlocks) {
                    if (processed >= 400) break;
                    this.explosion.level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    if (this.explosion.random.nextFloat() < 0.9f) {
                        this.explosion.level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                    }
                    ++processed;
                }
                if (this.tickCounter == 2) {
                    this.currentPhase = ExplosionPhase.SHOCK_WAVE;
                }
            }
        }

        private void processShockWave() {
            this.currentShockRadius += 3.5f;
            for (int processed = 0; this.shockIndex < this.shockBlocks.size() && processed < 400; ++processed) {
                float destructionChance;
                BlockData blockData = this.shockBlocks.get(this.shockIndex);
                if (blockData.distance > this.currentShockRadius) break;
                float f = destructionChance = blockData.reflectionAmplified ? 0.95f : 0.85f;
                if (this.explosion.random.nextFloat() < destructionChance) {
                    this.explosion.level.m_7731_(blockData.pos, Blocks.f_50016_.m_49966_(), 3);
                }
                ++this.shockIndex;
            }
            if (this.tickCounter >= 5 && this.currentPhase == ExplosionPhase.SHOCK_WAVE) {
                this.currentPhase = ExplosionPhase.BLAST_WIND;
            }
        }

        private void processBlastWind() {
            this.currentBlastRadius += 2.8f;
            for (int processed = 0; this.blastIndex < this.blastBlocks.size() && processed < 400; ++processed) {
                BlockData blockData = this.blastBlocks.get(this.blastIndex);
                if (blockData.distance > this.currentBlastRadius) break;
                float destructionChance = 0.6f;
                if (blockData.reflectionAmplified) {
                    destructionChance *= 1.4f;
                }
                if (this.explosion.random.nextFloat() < destructionChance) {
                    this.explosion.level.m_7731_(blockData.pos, Blocks.f_50016_.m_49966_(), 3);
                }
                ++this.blastIndex;
            }
            if (this.tickCounter >= 8) {
                this.currentPhase = ExplosionPhase.DEBRIS_EJECTION;
            }
        }

        private void processDebrisEjection() {
            int processed = 0;
            for (DebrisData debris : this.debrisObjects) {
                if (processed >= 150) break;
                if (debris.returningToCenter) continue;
                Vec3 newPos = new Vec3((double)debris.currentPos.m_123341_(), (double)debris.currentPos.m_123342_(), (double)debris.currentPos.m_123343_()).m_82549_(debris.velocity.m_82490_((double)0.8f));
                debris.currentPos = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_, (int)newPos.f_82481_);
                if (this.explosion.random.nextFloat() < 0.3f && this.explosion.level.m_8055_(debris.currentPos).m_60795_()) {
                    ItemStack itemStack = new ItemStack((ItemLike)debris.blockState.m_60734_().m_5456_());
                    ItemEntity itemEntity = new ItemEntity(this.explosion.level, (double)debris.currentPos.m_123341_(), (double)debris.currentPos.m_123342_(), (double)debris.currentPos.m_123343_(), itemStack);
                    this.explosion.level.m_7967_((Entity)itemEntity);
                }
                ++processed;
            }
            if (this.tickCounter >= 20) {
                this.currentPhase = ExplosionPhase.NEGATIVE_PHASE;
                for (DebrisData debris : this.debrisObjects) {
                    debris.returningToCenter = true;
                }
            }
        }

        private void processNegativePhase() {
            this.currentSuctionRadius += 1.2f;
            int processed = 0;
            for (DebrisData debris : this.debrisObjects) {
                if (processed >= 150) break;
                if (!debris.returningToCenter) continue;
                Vec3 centerPos = new Vec3(this.explosion.x, this.explosion.y, this.explosion.z);
                Vec3 debrisPos = new Vec3((double)debris.currentPos.m_123341_(), (double)debris.currentPos.m_123342_(), (double)debris.currentPos.m_123343_());
                Vec3 pullDirection = centerPos.m_82546_(debrisPos).m_82541_();
                Vec3 newPos = debrisPos.m_82549_(pullDirection.m_82490_((double)0.6f));
                debris.currentPos = new BlockPos((int)newPos.f_82479_, (int)newPos.f_82480_, (int)newPos.f_82481_);
                ++processed;
            }
            if (this.tickCounter >= 35) {
                this.currentPhase = ExplosionPhase.FIREBALL_RISE;
            }
        }

        private void processFireballRise() {
            this.fireballHeight += 0.15f;
            this.fireballTemperature = Math.max(800, this.fireballTemperature - 4);
            int fireY = (int)(this.explosion.y + (double)this.fireballHeight);
            for (int dx = -this.explosion.fireballRadius / 2; dx <= this.explosion.fireballRadius / 2; ++dx) {
                for (int dz = -this.explosion.fireballRadius / 2; dz <= this.explosion.fireballRadius / 2; ++dz) {
                    BlockPos firePos;
                    if (dx * dx + dz * dz > this.explosion.fireballRadius / 2 * (this.explosion.fireballRadius / 2) || !this.explosion.level.m_8055_(firePos = new BlockPos((int)this.explosion.x + dx, fireY, (int)this.explosion.z + dz)).m_60795_() || !(this.explosion.random.nextFloat() < 0.4f)) continue;
                    this.explosion.level.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
            if (this.fireballTemperature <= 800) {
                this.currentPhase = ExplosionPhase.SECONDARY_FIRES;
            }
        }

        private void processSecondaryFires() {
            if (this.tickCounter % 3 == 0) {
                for (int i = 0; i < 10; ++i) {
                    int pz;
                    int py;
                    int px = (int)(this.explosion.x + (double)((this.explosion.random.nextFloat() - 0.5f) * (float)this.explosion.blastRadius * 2.0f));
                    BlockPos pos = new BlockPos(px, py = (int)(this.explosion.y + (double)((this.explosion.random.nextFloat() - 0.5f) * (float)this.explosion.blastRadius)), pz = (int)(this.explosion.z + (double)((this.explosion.random.nextFloat() - 0.5f) * (float)this.explosion.blastRadius * 2.0f)));
                    if (!this.explosion.level.m_8055_(pos).m_60795_() || !(this.explosion.random.nextFloat() < 0.1f)) continue;
                    this.explosion.level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
            if (this.tickCounter >= 100) {
                this.currentPhase = ExplosionPhase.COMPLETE;
            }
        }

        boolean isComplete() {
            return this.currentPhase == ExplosionPhase.COMPLETE;
        }

        private static enum ExplosionPhase {
            FIREBALL_FORMATION,
            SHOCK_WAVE,
            BLAST_WIND,
            DEBRIS_EJECTION,
            NEGATIVE_PHASE,
            FIREBALL_RISE,
            SECONDARY_FIRES,
            COMPLETE;

        }

        private static class BlockData {
            final BlockPos pos;
            final float distance;
            final BlockState originalState;
            final boolean reflectionAmplified;

            BlockData(BlockPos pos, float distance, BlockState state, boolean amplified) {
                this.pos = pos;
                this.distance = distance;
                this.originalState = state;
                this.reflectionAmplified = amplified;
            }
        }

        private static class DebrisData {
            final BlockPos originalPos;
            BlockPos currentPos;
            final Vec3 velocity;
            final BlockState blockState;
            final boolean isHeavy;
            boolean returningToCenter = false;

            DebrisData(BlockPos pos, Vec3 vel, BlockState state, boolean heavy) {
                this.originalPos = pos;
                this.currentPos = pos;
                this.velocity = vel;
                this.blockState = state;
                this.isHeavy = heavy;
            }
        }
    }
}

