/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.keerdm.item_scrapper.configs.json.TransformConfig;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="item_scrapper")
public class TransformDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(TransformConfig.Transform.class, (Object)new TransformDeserializer()).create();
    private static TransformDataManager INSTANCE;
    private Map<String, List<TransformConfig.Transform>> itemToTransformsMap = new HashMap<String, List<TransformConfig.Transform>>();

    public TransformDataManager() {
        super(GSON, "item_scrapper/transforms");
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new TransformDataManager());
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.itemToTransformsMap.clear();
        ItemScrapperLogger.debugLog("Loading transform configs from datapacks and mods...");
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry configEntry : jsonObject.entrySet()) {
                    TransformConfig.Transform transform;
                    String itemId = (String)configEntry.getKey();
                    JsonElement value = (JsonElement)configEntry.getValue();
                    ArrayList<TransformConfig.Transform> transforms = new ArrayList<TransformConfig.Transform>();
                    if (value.isJsonArray()) {
                        JsonArray array = value.getAsJsonArray();
                        for (JsonElement element : array) {
                            TransformConfig.Transform transform2 = (TransformConfig.Transform)GSON.fromJson(element, TransformConfig.Transform.class);
                            if (transform2 == null) continue;
                            transforms.add(transform2);
                            ItemScrapperLogger.debugLog("Loaded transform for " + itemId + " with NBT: " + transform2.requiredNbt + " from " + location);
                        }
                    } else if (value.isJsonObject() && (transform = (TransformConfig.Transform)GSON.fromJson(value, TransformConfig.Transform.class)) != null) {
                        transforms.add(transform);
                        ItemScrapperLogger.debugLog("Loaded transform for " + itemId + " with NBT: " + transform.requiredNbt + " from " + location);
                    }
                    if (transforms.isEmpty()) continue;
                    if (this.itemToTransformsMap.containsKey(itemId)) {
                        this.itemToTransformsMap.get(itemId).addAll(transforms);
                        continue;
                    }
                    this.itemToTransformsMap.put(itemId, transforms);
                }
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("Error loading transform config from " + location + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        ItemScrapperLogger.debugLog("Loaded " + this.itemToTransformsMap.size() + " transform configurations from datapacks and mods");
    }

    public static TransformConfig.Transform getTransformForItem(String itemId, CompoundTag nbt) {
        if (INSTANCE == null) {
            return null;
        }
        List<TransformConfig.Transform> transforms = TransformDataManager.INSTANCE.itemToTransformsMap.get(itemId);
        if (transforms == null) {
            return null;
        }
        for (TransformConfig.Transform transform : transforms) {
            if (!transform.matchesNbt(nbt)) continue;
            return transform;
        }
        return null;
    }

    public static Map<String, List<TransformConfig.Transform>> getAllTransforms() {
        return INSTANCE != null ? TransformDataManager.INSTANCE.itemToTransformsMap : new HashMap<String, List<TransformConfig.Transform>>();
    }

    private static class TransformDeserializer
    implements JsonDeserializer<TransformConfig.Transform> {
        private TransformDeserializer() {
        }

        public TransformConfig.Transform deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            double xLocation = obj.has("xLocation") ? obj.get("xLocation").getAsDouble() : 0.0;
            double yLocation = obj.has("yLocation") ? obj.get("yLocation").getAsDouble() : 0.0;
            double zLocation = obj.has("zLocation") ? obj.get("zLocation").getAsDouble() : 0.0;
            double layingRotation = obj.has("layingRotation") ? obj.get("layingRotation").getAsDouble() : 0.0;
            double scale = obj.has("scale") ? obj.get("scale").getAsDouble() : 1.0;
            String requiredNbt = obj.has("requiredNbt") ? obj.get("requiredNbt").getAsString() : null;
            return new TransformConfig.Transform(xLocation, yLocation, zLocation, layingRotation, scale, requiredNbt);
        }
    }
}

