/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.keerdm.item_scrapper.configs.RoundingType;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ConfigChunkManager;
import com.keerdm.item_scrapper.events.ConfigWarningSystem;
import com.keerdm.item_scrapper.networking.ModNetworking;
import com.keerdm.item_scrapper.packets.SyncConfigDataPacket;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="item_scrapper")
public class ScrapperDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Scrapper_conversionsConfig.ScrapConfig.class, (Object)new ScrapConfigDeserializer()).registerTypeAdapter(Scrapper_conversionsConfig.LootableConfig.class, (Object)new LootableConfigDeserializer()).create();
    private static final Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> CLIENT_CONFIGS = new ConcurrentHashMap<String, List<Scrapper_conversionsConfig.ScrapConfig>>();
    private static final Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> SERVER_CONFIGS = new ConcurrentHashMap<String, List<Scrapper_conversionsConfig.ScrapConfig>>();
    private static boolean CLIENT_SYNCED = false;
    private static long LAST_SYNC_TIME = 0L;

    public ScrapperDataManager() {
        super(GSON, "item_scrapper/recipes");
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ScrapperDataManager());
        String side = FMLEnvironment.dist.isClient() ? "CLIENT" : "SERVER";
        ItemScrapperLogger.debugLog("Registered reload listener on " + side);
    }

    public static void updateClientConfigs(Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> configData) {
        if (FMLEnvironment.dist.isClient()) {
            CLIENT_CONFIGS.clear();
            CLIENT_CONFIGS.putAll(configData);
            CLIENT_SYNCED = true;
            LAST_SYNC_TIME = System.currentTimeMillis();
            ItemScrapperLogger.debugLog("CLIENT: Updated configs from server. Total: " + configData.size());
            int count = 0;
            for (String itemId : configData.keySet()) {
                if (count >= 3) continue;
                ItemScrapperLogger.debugLog("CLIENT: Has config for " + itemId);
                ++count;
            }
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        String side = FMLEnvironment.dist.isClient() ? "CLIENT" : "SERVER";
        ItemScrapperLogger.debugLog(side + ": Loading configs from " + resourceLocationJsonElementMap.size() + " files");
        HashMap loadedConfigs = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry configEntry : jsonObject.entrySet()) {
                    Scrapper_conversionsConfig.ScrapConfig config;
                    String itemId = (String)configEntry.getKey();
                    JsonElement value = (JsonElement)configEntry.getValue();
                    ArrayList<Scrapper_conversionsConfig.ScrapConfig> configs = new ArrayList<Scrapper_conversionsConfig.ScrapConfig>();
                    if (value.isJsonArray()) {
                        JsonArray array = value.getAsJsonArray();
                        for (JsonElement element : array) {
                            Scrapper_conversionsConfig.ScrapConfig config2 = (Scrapper_conversionsConfig.ScrapConfig)GSON.fromJson(element, Scrapper_conversionsConfig.ScrapConfig.class);
                            if (config2 == null || !config2.lootable.isValid()) continue;
                            configs.add(config2);
                        }
                    } else if (value.isJsonObject() && (config = (Scrapper_conversionsConfig.ScrapConfig)GSON.fromJson(value, Scrapper_conversionsConfig.ScrapConfig.class)) != null && config.lootable.isValid()) {
                        configs.add(config);
                    }
                    if (configs.isEmpty()) continue;
                    if (loadedConfigs.containsKey(itemId)) {
                        ((List)loadedConfigs.get(itemId)).addAll(configs);
                        continue;
                    }
                    loadedConfigs.put(itemId, configs);
                }
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("Error loading from " + location + ": " + e.getMessage(), e);
            }
        }
        ItemScrapperLogger.debugLog(side + ": Loaded " + loadedConfigs.size() + " total configs");
        if (FMLEnvironment.dist.isClient()) {
            CLIENT_CONFIGS.clear();
            CLIENT_CONFIGS.putAll(loadedConfigs);
            CLIENT_SYNCED = true;
        } else {
            SERVER_CONFIGS.clear();
            SERVER_CONFIGS.putAll(loadedConfigs);
            ScrapperDataManager.syncToAllPlayers();
        }
        ConfigWarningSystem.resetWarningState();
    }

    private static void syncToAllPlayers() {
        try {
            List players;
            if (ServerLifecycleHooks.getCurrentServer() != null && !(players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()).isEmpty()) {
                SyncConfigDataPacket[] packets = SyncConfigDataPacket.createChunkedPackets(SERVER_CONFIGS);
                ItemScrapperLogger.debugLog("SERVER: Syncing to " + players.size() + " players (" + packets.length + " packets)");
                for (ServerPlayer player : players) {
                    for (SyncConfigDataPacket packet : packets) {
                        ModNetworking.sendToPlayer(packet, player);
                    }
                }
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("SERVER: Sync failed: " + e.getMessage(), e);
        }
    }

    public static Scrapper_conversionsConfig.ScrapConfig getConfigForItem(String itemId, CompoundTag nbt) {
        List<Scrapper_conversionsConfig.ScrapConfig> configList;
        Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> configs;
        if (FMLEnvironment.dist.isClient()) {
            configs = CLIENT_CONFIGS;
            if (!CLIENT_SYNCED || configs.isEmpty()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime % 5000L < 100L) {
                    ItemScrapperLogger.debugLog("CLIENT: No configs available (synced: " + CLIENT_SYNCED + ", count: " + configs.size() + ")");
                }
                return null;
            }
        } else {
            configs = SERVER_CONFIGS;
        }
        if ((configList = configs.get(itemId)) == null) {
            return null;
        }
        for (Scrapper_conversionsConfig.ScrapConfig config : configList) {
            if (!config.matchesNbt(nbt)) continue;
            return config;
        }
        return null;
    }

    public static Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> getAllConfigs() {
        if (FMLEnvironment.dist.isClient()) {
            return new HashMap<String, List<Scrapper_conversionsConfig.ScrapConfig>>(CLIENT_CONFIGS);
        }
        return new HashMap<String, List<Scrapper_conversionsConfig.ScrapConfig>>(SERVER_CONFIGS);
    }

    public static void handleConfigChunk(String chunkData, int chunkIndex, int totalChunks, String sessionId) {
        ConfigChunkManager.handleChunk(chunkData, chunkIndex, totalChunks, sessionId);
    }

    public static boolean isClientSynced() {
        return CLIENT_SYNCED;
    }

    public static long getLastSyncTime() {
        return LAST_SYNC_TIME;
    }

    public static void syncToPlayer(ServerPlayer player) {
        try {
            if (!SERVER_CONFIGS.isEmpty()) {
                SyncConfigDataPacket[] packets = SyncConfigDataPacket.createChunkedPackets(SERVER_CONFIGS);
                ItemScrapperLogger.debugLog("SERVER: Force syncing " + SERVER_CONFIGS.size() + " configs to " + player.m_7755_().getString());
                for (SyncConfigDataPacket packet : packets) {
                    ModNetworking.sendToPlayer(packet, player);
                }
            } else {
                ItemScrapperLogger.debugLog("SERVER: No configs to sync to " + player.m_7755_().getString());
            }
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("SERVER: Force sync failed for " + player.m_7755_().getString() + ": " + e.getMessage(), e);
        }
    }

    private static class ScrapConfigDeserializer
    implements JsonDeserializer<Scrapper_conversionsConfig.ScrapConfig> {
        private ScrapConfigDeserializer() {
        }

        public Scrapper_conversionsConfig.ScrapConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            Scrapper_conversionsConfig.LootableConfig lootable = (Scrapper_conversionsConfig.LootableConfig)context.deserialize(obj.get("lootable"), Scrapper_conversionsConfig.LootableConfig.class);
            double requiredHits = obj.get("requiredHits").getAsDouble();
            double explosionChance = obj.has("explosionChance") ? obj.get("explosionChance").getAsDouble() : 0.0;
            double explosionPower = obj.has("explosionPower") ? obj.get("explosionPower").getAsDouble() : 0.0;
            String requiredNbt = obj.has("requiredNbt") ? obj.get("requiredNbt").getAsString() : null;
            boolean useDurabilityMultiplier = obj.has("useDurabilityMultiplier") ? obj.get("useDurabilityMultiplier").getAsBoolean() : false;
            RoundingType roundingType = obj.has("roundingType") ? RoundingType.fromString(obj.get("roundingType").getAsString()) : RoundingType.STANDARD;
            return new Scrapper_conversionsConfig.ScrapConfig(lootable, requiredHits, explosionChance, explosionPower, requiredNbt, useDurabilityMultiplier, roundingType);
        }
    }

    private static class LootableConfigDeserializer
    implements JsonDeserializer<Scrapper_conversionsConfig.LootableConfig> {
        private LootableConfigDeserializer() {
        }

        public Scrapper_conversionsConfig.LootableConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("autoGenerateFromRecipe") && obj.get("autoGenerateFromRecipe").getAsBoolean()) {
                JsonObject returnAmountObj = obj.get("returnAmount").getAsJsonObject();
                Scrapper_conversionsConfig.ReturnAmount returnAmount = new Scrapper_conversionsConfig.ReturnAmount(returnAmountObj.get("min").getAsDouble(), returnAmountObj.get("max").getAsDouble());
                int amountForMaxReturn = obj.get("amountForMaxReturn").getAsInt();
                ArrayList<String> recipeIds = new ArrayList<String>();
                if (obj.has("recipeId")) {
                    if (obj.get("recipeId").isJsonArray()) {
                        obj.get("recipeId").getAsJsonArray().forEach(element -> recipeIds.add(element.getAsString()));
                    } else {
                        recipeIds.add(obj.get("recipeId").getAsString());
                    }
                } else if (obj.has("recipeIds")) {
                    obj.get("recipeIds").getAsJsonArray().forEach(element -> recipeIds.add(element.getAsString()));
                }
                return Scrapper_conversionsConfig.LootableConfig.fromRecipes(recipeIds, returnAmount, amountForMaxReturn);
            }
            return Scrapper_conversionsConfig.LootableConfig.fromLootTable(obj.get("lootTable").getAsString());
        }
    }
}

