/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigChunkManager {
    private static final Gson GSON = new Gson();
    private static final Map<String, ChunkSession> activeSessions = new ConcurrentHashMap<String, ChunkSession>();

    public static void handleChunk(String chunkData, int chunkIndex, int totalChunks, String sessionId) {
        ItemScrapperLogger.debugLog("CLIENT: Received chunk " + (chunkIndex + 1) + "/" + totalChunks + " (size: " + chunkData.length() + ")");
        ChunkSession session = activeSessions.computeIfAbsent(sessionId, id -> {
            ItemScrapperLogger.debugLog("CLIENT: Starting new chunk session " + sessionId);
            return new ChunkSession(totalChunks);
        });
        session.addChunk(chunkIndex, chunkData);
        if (session.isComplete()) {
            try {
                ItemScrapperLogger.debugLog("CLIENT: All chunks received, assembling...");
                String completeJson = session.assembleData();
                Type type = new TypeToken<Map<String, List<Scrapper_conversionsConfig.ScrapConfig>>>(){}.getType();
                Map configData = (Map)GSON.fromJson(completeJson, type);
                ItemScrapperLogger.debugLog("CLIENT: Successfully parsed " + configData.size() + " configs");
                ScrapperDataManager.updateClientConfigs(configData);
                activeSessions.remove(sessionId);
                ItemScrapperLogger.debugLog("CLIENT: Config sync completed!");
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("CLIENT: Error assembling chunks: " + e.getMessage(), e);
                activeSessions.remove(sessionId);
            }
        }
    }

    private static class ChunkSession {
        private final String[] chunks;
        private final boolean[] received;
        private final int totalChunks;
        private int receivedCount = 0;

        public ChunkSession(int totalChunks) {
            this.totalChunks = totalChunks;
            this.chunks = new String[totalChunks];
            this.received = new boolean[totalChunks];
        }

        public void addChunk(int index, String data) {
            if (index >= 0 && index < this.totalChunks && !this.received[index]) {
                this.chunks[index] = data;
                this.received[index] = true;
                ++this.receivedCount;
                ItemScrapperLogger.debugLog("CLIENT: Added chunk " + index + ", progress: " + this.receivedCount + "/" + this.totalChunks);
            } else {
                ItemScrapperLogger.debugLog("CLIENT: Invalid chunk index " + index + " or already received");
            }
        }

        public boolean isComplete() {
            return this.receivedCount == this.totalChunks;
        }

        public String assembleData() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.chunks.length; ++i) {
                if (this.chunks[i] == null) {
                    throw new RuntimeException("Missing chunk at index " + i);
                }
                sb.append(this.chunks[i]);
            }
            return sb.toString();
        }
    }
}

