/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.configs.json;

import com.keerdm.item_scrapper.data.TransformDataManager;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;

public class TransformConfig {
    public static Transform getTransformForItem(String itemId, CompoundTag nbt) {
        return TransformDataManager.getTransformForItem(itemId, nbt);
    }

    public static Map<String, List<Transform>> getAllTransforms() {
        return TransformDataManager.getAllTransforms();
    }

    public static void reloadConfig() {
        ItemScrapperLogger.debugLog("Transform config reload requested - handled by datapack system");
    }

    public static class Transform {
        public double xLocation;
        public double yLocation;
        public double zLocation;
        public double layingRotation;
        public double scale;
        public String requiredNbt;

        public Transform() {
            this(0.0, 0.0, 0.0, 0.0, 1.0, null);
        }

        public Transform(double xLocation, double yLocation, double zLocation, double layingRotation, double scale, String requiredNbt) {
            this.xLocation = xLocation;
            this.yLocation = yLocation;
            this.zLocation = zLocation;
            this.layingRotation = layingRotation;
            this.scale = scale;
            this.requiredNbt = requiredNbt;
        }

        public boolean matchesNbt(CompoundTag itemNbt) {
            if (this.requiredNbt == null || this.requiredNbt.isEmpty()) {
                return true;
            }
            if (itemNbt == null) {
                return false;
            }
            try {
                CompoundTag requiredTag = TagParser.m_129359_((String)this.requiredNbt);
                return this.matchesNbtRecursive(requiredTag, itemNbt);
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("Error parsing required NBT: " + e.getMessage());
                return false;
            }
        }

        private boolean matchesNbtRecursive(CompoundTag required, CompoundTag actual) {
            for (String key : required.m_128431_()) {
                if (!actual.m_128441_(key)) {
                    return false;
                }
                if (required.m_128423_(key) instanceof CompoundTag) {
                    if (!(actual.m_128423_(key) instanceof CompoundTag)) {
                        return false;
                    }
                    if (this.matchesNbtRecursive((CompoundTag)required.m_128423_(key), (CompoundTag)actual.m_128423_(key))) continue;
                    return false;
                }
                if (required.m_128423_(key).equals(actual.m_128423_(key))) continue;
                return false;
            }
            return true;
        }
    }
}

