/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.configs.json;

import com.keerdm.item_scrapper.configs.RoundingType;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;

public class Scrapper_conversionsConfig {
    public static ScrapConfig getConfigForItem(String itemId, CompoundTag nbt) {
        return ScrapperDataManager.getConfigForItem(itemId, nbt);
    }

    public static Map<String, List<ScrapConfig>> getAllConfigs() {
        return ScrapperDataManager.getAllConfigs();
    }

    public static class ScrapConfig {
        public LootableConfig lootable;
        public double requiredHits;
        public double explosionChance = 0.0;
        public double explosionPower = 0.0;
        public String requiredNbt;
        public boolean useDurabilityMultiplier = false;
        public RoundingType roundingType = RoundingType.STANDARD;

        public ScrapConfig(LootableConfig lootable, double requiredHits, double explosionChance, double explosionPower, String requiredNbt, boolean useDurabilityMultiplier, RoundingType roundingType) {
            this.lootable = lootable;
            this.requiredHits = requiredHits;
            this.explosionChance = Math.max(0.0, Math.min(100.0, explosionChance));
            this.explosionPower = explosionPower;
            this.requiredNbt = requiredNbt;
            this.useDurabilityMultiplier = useDurabilityMultiplier;
            this.roundingType = roundingType != null ? roundingType : RoundingType.STANDARD;
        }

        public ScrapConfig(LootableConfig lootable, double requiredHits, double explosionChance, double explosionPower, String requiredNbt, boolean useDurabilityMultiplier) {
            this(lootable, requiredHits, explosionChance, explosionPower, requiredNbt, useDurabilityMultiplier, RoundingType.STANDARD);
        }

        public boolean matchesNbt(CompoundTag itemNbt) {
            if (this.requiredNbt == null || this.requiredNbt.isEmpty()) {
                return true;
            }
            if (itemNbt == null) {
                return false;
            }
            try {
                CompoundTag requiredTag = TagParser.m_129359_((String)this.requiredNbt);
                return this.matchesNbtRecursive(requiredTag, itemNbt);
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("Error parsing required NBT: " + e.getMessage());
                return false;
            }
        }

        private boolean matchesNbtRecursive(CompoundTag required, CompoundTag actual) {
            for (String key : required.m_128431_()) {
                if (!actual.m_128441_(key)) {
                    return false;
                }
                if (required.m_128423_(key) instanceof CompoundTag) {
                    if (!(actual.m_128423_(key) instanceof CompoundTag)) {
                        return false;
                    }
                    if (this.matchesNbtRecursive((CompoundTag)required.m_128423_(key), (CompoundTag)actual.m_128423_(key))) continue;
                    return false;
                }
                if (required.m_128423_(key).equals(actual.m_128423_(key))) continue;
                return false;
            }
            return true;
        }
    }

    public static class LootableConfig {
        private String lootTable;
        private boolean autoGenerateFromRecipe = false;
        private List<String> recipeIds;
        private ReturnAmount returnAmount;
        private int amountForMaxReturn = 1;

        public static LootableConfig fromLootTable(String lootTable) {
            LootableConfig config = new LootableConfig();
            config.lootTable = lootTable;
            return config;
        }

        public static LootableConfig fromRecipe(String recipeId, ReturnAmount returnAmount, int amountForMaxReturn) {
            LootableConfig config = new LootableConfig();
            config.autoGenerateFromRecipe = true;
            config.recipeIds = new ArrayList<String>();
            config.recipeIds.add(recipeId);
            config.returnAmount = returnAmount;
            config.amountForMaxReturn = Math.max(1, amountForMaxReturn);
            return config;
        }

        public static LootableConfig fromRecipes(List<String> recipeIds, ReturnAmount returnAmount, int amountForMaxReturn) {
            LootableConfig config = new LootableConfig();
            config.autoGenerateFromRecipe = true;
            config.recipeIds = new ArrayList<String>(recipeIds);
            config.returnAmount = returnAmount;
            config.amountForMaxReturn = Math.max(1, amountForMaxReturn);
            return config;
        }

        public String getLootTable() {
            return this.lootTable;
        }

        public boolean isAutoGenerateFromRecipe() {
            return this.autoGenerateFromRecipe;
        }

        public String getRecipeId() {
            return this.recipeIds != null && !this.recipeIds.isEmpty() ? this.recipeIds.get(0) : null;
        }

        public List<String> getRecipeIds() {
            return this.recipeIds != null ? this.recipeIds : new ArrayList<String>();
        }

        public ReturnAmount getReturnAmount() {
            return this.returnAmount;
        }

        public int getAmountForMaxReturn() {
            return this.amountForMaxReturn;
        }

        public boolean isValid() {
            if (this.autoGenerateFromRecipe) {
                return this.recipeIds != null && !this.recipeIds.isEmpty() && this.returnAmount != null;
            }
            return this.lootTable != null && !this.lootTable.isEmpty();
        }
    }

    public static class ReturnAmount {
        public double min = 0.0;
        public double max = 100.0;

        public ReturnAmount() {
        }

        public ReturnAmount(double min, double max) {
            this.min = Math.max(0.0, Math.min(100.0, min));
            this.max = Math.max(0.0, Math.min(100.0, max));
            if (this.min > this.max) {
                double temp = this.min;
                this.min = this.max;
                this.max = temp;
            }
        }
    }
}

