/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.keerdm.item_scrapper.configs.CommonConfig;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String GENERATED_DATAPACK_PATH = "generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper";
    private static final String RECIPES_PATH = "generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper/recipes";
    private static final String TRANSFORMS_PATH = "generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper/transforms";
    private static final String TACZ_CUSTOM_PATH = "config/tacz/custom";
    private static boolean hasGenerated = false;

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ItemScrapperLogger.debugLog("Creating initial directory structure...");
        event.enqueueWork(() -> ConfigGenerator.createDirectoryStructure());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!hasGenerated) {
            ItemScrapperLogger.debugLog("Server started, generating configs now that tags are loaded...");
            ConfigGenerator.generateConfigs();
            hasGenerated = true;
        }
    }

    private static void createDirectoryStructure() {
        try {
            Files.createDirectories(Path.of(RECIPES_PATH, new String[0]), new FileAttribute[0]);
            Files.createDirectories(Path.of(TRANSFORMS_PATH, new String[0]), new FileAttribute[0]);
            ConfigGenerator.createPackMcmeta();
            ItemScrapperLogger.debugLog("Successfully created generated datapack structure");
            ItemScrapperLogger.debugLog("Generated configs will be placed in: generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper");
            ItemScrapperLogger.debugLog("To use generated configs, copy the generated_datapacks/item_scrapper_generated folder to your world's datapacks folder");
        }
        catch (IOException e) {
            ItemScrapperLogger.errorLog("ERROR creating directories: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void createPackMcmeta() {
        try {
            HashMap pack = new HashMap();
            HashMap<String, Object> packInfo = new HashMap<String, Object>();
            packInfo.put("pack_format", 15);
            packInfo.put("description", "Auto-generated Item Scrapper configurations\n\u00a77Copy to world datapacks folder to use");
            pack.put("pack", packInfo);
            File packMcmeta = new File("generated_datapacks/item_scrapper_generated", "pack.mcmeta");
            packMcmeta.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(packMcmeta);){
                GSON.toJson(pack, (Appendable)writer);
            }
        }
        catch (IOException e) {
            ItemScrapperLogger.errorLog("Error creating pack.mcmeta: " + e.getMessage());
        }
    }

    public static void generateConfigs() {
        ItemScrapperLogger.debugLog("Checking if auto generation is enabled...");
        if (!((Boolean)CommonConfig.ENABLE_AUTO_GENERATION.get()).booleanValue()) {
            ItemScrapperLogger.debugLog("Auto generation is disabled. Skipping config generation.");
            return;
        }
        ItemScrapperLogger.debugLog("Getting item tags from config...");
        List itemTags = (List)CommonConfig.ITEM_TAGS.get();
        ItemScrapperLogger.debugLog("Found " + itemTags.size() + " tags to process");
        for (String tagString : itemTags) {
            ItemScrapperLogger.debugLog("Processing tag: " + tagString);
            if (tagString.equals("tacz:guns")) {
                ConfigGenerator.generateTaczGunConfigs();
                continue;
            }
            if (tagString.equals("pointblank:all")) {
                ConfigGenerator.generatePointblankConfigs();
                continue;
            }
            ResourceLocation tagLocation = new ResourceLocation(tagString);
            TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagLocation);
            ITagManager tagManager = ForgeRegistries.ITEMS.tags();
            if (tagManager == null) {
                ItemScrapperLogger.errorLog("ERROR: Tag manager is still null for " + tagString);
                continue;
            }
            ITag optionalTag = tagManager.getTag(tagKey);
            ArrayList<Item> itemsInTag = new ArrayList<Item>();
            optionalTag.forEach(itemsInTag::add);
            ItemScrapperLogger.debugLog("Found " + itemsInTag.size() + " items in tag: " + tagString);
            ConfigGenerator.processItems(itemsInTag);
        }
        ItemScrapperLogger.debugLog("Getting individual items from config...");
        List individualItems = (List)CommonConfig.INDIVIDUAL_ITEMS.get();
        ItemScrapperLogger.debugLog("Found " + individualItems.size() + " individual items to process");
        for (String itemString : individualItems) {
            ItemScrapperLogger.debugLog("Processing individual item: " + itemString);
            try {
                ResourceLocation itemLocation = new ResourceLocation(itemString);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                if (item != null && !item.equals(Items.f_41852_)) {
                    List<Item> singleItemList = Arrays.asList(item);
                    ItemScrapperLogger.debugLog("Successfully found item: " + itemString);
                    ConfigGenerator.processItems(singleItemList);
                    continue;
                }
                ItemScrapperLogger.errorLog("ERROR: Could not find item: " + itemString);
            }
            catch (Exception e) {
                ItemScrapperLogger.errorLog("ERROR processing individual item " + itemString + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        ItemScrapperLogger.debugLog("Config generation completed");
        ItemScrapperLogger.debugLog("Generated configs are in: generated_datapacks/item_scrapper_generated/");
        ItemScrapperLogger.debugLog("To use them, copy this folder to your world's datapacks folder and run /reload");
    }

    private static void generatePointblankConfigs() {
        ItemScrapperLogger.debugLog("Generating configs for all Pointblank items...");
        ArrayList<Item> pointblankItems = new ArrayList<Item>();
        ForgeRegistries.ITEMS.forEach(item -> {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey(item);
            if (itemId != null && itemId.m_135827_().equals("pointblank")) {
                pointblankItems.add((Item)item);
            }
        });
        ItemScrapperLogger.debugLog("Found " + pointblankItems.size() + " Pointblank items");
        ConfigGenerator.processItems(pointblankItems);
    }

    private static void processItems(List<Item> items) {
        for (Item item : items) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemId != null) {
                ItemScrapperLogger.debugLog("Processing item: " + itemId);
                if (((Boolean)CommonConfig.USE_RECIPE_BASED_LOOT.get()).booleanValue()) {
                    String recipeFileName = itemId.m_135827_() + "_" + itemId.m_135815_() + "_result.json";
                    File recipeFile = new File(RECIPES_PATH, recipeFileName);
                    if (!recipeFile.exists()) {
                        ItemScrapperLogger.debugLog("Generating recipe config for: " + itemId);
                        ConfigGenerator.generateRecipeConfig(itemId);
                    } else {
                        ItemScrapperLogger.debugLog("Recipe config already exists for: " + itemId + ", skipping generation");
                    }
                }
                if (!((Boolean)CommonConfig.GENERATE_TRANSFORMS.get()).booleanValue()) continue;
                String transformFileName = itemId.m_135827_() + "_" + itemId.m_135815_() + "_transform.json";
                File transformFile = new File(TRANSFORMS_PATH, transformFileName);
                if (!transformFile.exists()) {
                    ItemScrapperLogger.debugLog("Generating transform config for: " + itemId);
                    ConfigGenerator.generateTransformConfig(itemId);
                    continue;
                }
                ItemScrapperLogger.debugLog("Transform config already exists for: " + itemId + ", skipping generation");
                continue;
            }
            ItemScrapperLogger.debugLog("WARNING: Null item ID found");
        }
    }

    private static void generateTaczGunConfigs() {
        ItemScrapperLogger.debugLog("Generating TACZ gun configs...");
        Path basePath = (Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get() != false ? Paths.get("tacz", new String[0]) : Paths.get(TACZ_CUSTOM_PATH, new String[0]);
        try {
            if (!Files.exists(basePath, new LinkOption[0])) {
                ItemScrapperLogger.debugLog("TACZ folder not found at: " + basePath);
                return;
            }
            List gunFolders = Files.list(basePath).filter(path -> path.getFileName().toString().endsWith("_default_gun")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            ItemScrapperLogger.debugLog("Found " + gunFolders.size() + " gun folders in " + basePath);
            for (Path gunFolder : gunFolders) {
                String folderName = gunFolder.getFileName().toString();
                ItemScrapperLogger.debugLog("Processing gun folder: " + folderName);
                String addonPrefix = ConfigGenerator.determineAddonPrefix(gunFolder);
                ItemScrapperLogger.debugLog("Using addon prefix: " + addonPrefix);
                Path recipePath = (Boolean)CommonConfig.USE_NEW_TACZ_FORMAT.get() != false ? gunFolder.resolve("data").resolve(addonPrefix).resolve("recipes/gun") : gunFolder.resolve(addonPrefix).resolve("recipes/gun");
                ItemScrapperLogger.debugLog("Looking for recipes in: " + recipePath);
                if (Files.exists(recipePath, new LinkOption[0])) {
                    ItemScrapperLogger.debugLog("Found recipe folder: " + recipePath);
                    DirectoryStream<Path> recipeFiles = Files.newDirectoryStream(recipePath, "*.json");
                    try {
                        for (Path recipeFile : recipeFiles) {
                            String gunName = recipeFile.getFileName().toString().replace(".json", "");
                            String fullGunId = addonPrefix + ":" + gunName;
                            ItemScrapperLogger.debugLog("Processing gun: " + fullGunId);
                            if (!ConfigGenerator.configsExistForGun(addonPrefix, gunName)) {
                                ItemScrapperLogger.debugLog("Generating new configs for gun: " + fullGunId);
                                ConfigGenerator.generateGunConfigs(addonPrefix, gunName, fullGunId);
                                continue;
                            }
                            ItemScrapperLogger.debugLog("Configs already exist for gun: " + fullGunId + ", skipping generation");
                        }
                        continue;
                    }
                    finally {
                        if (recipeFiles != null) {
                            recipeFiles.close();
                        }
                        continue;
                    }
                }
                ItemScrapperLogger.debugLog("No recipe folder found at: " + recipePath);
            }
        }
        catch (IOException e) {
            ItemScrapperLogger.errorLog("ERROR scanning TACZ gun folders: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String determineAddonPrefix(Path gunFolder) {
        String folderName = gunFolder.getFileName().toString();
        return folderName.replace("_default_gun", "");
    }

    private static void generateGunConfigs(String addonPrefix, String gunName, String fullGunId) {
        HashMap recipeConfig = new HashMap();
        ArrayList<Map<String, Object>> recipeConfigList = new ArrayList<Map<String, Object>>();
        Map<String, Object> recipeData = ConfigGenerator.createGunRecipeData(fullGunId);
        recipeConfigList.add(recipeData);
        recipeConfig.put("tacz:modern_kinetic_gun", recipeConfigList);
        HashMap transformConfig = new HashMap();
        ArrayList<Map<String, Object>> transformConfigList = new ArrayList<Map<String, Object>>();
        Map<String, Object> transformData = ConfigGenerator.createGunTransformData(fullGunId);
        transformConfigList.add(transformData);
        transformConfig.put("tacz:modern_kinetic_gun", transformConfigList);
        String recipeFileName = addonPrefix + "_" + gunName + "_result.json";
        String transformFileName = addonPrefix + "_" + gunName + "_transform.json";
        ItemScrapperLogger.debugLog("Saving recipe config as: " + recipeFileName);
        ItemScrapperLogger.debugLog("Saving transform config as: " + transformFileName);
        ConfigGenerator.saveJsonToFile(recipeConfig, RECIPES_PATH, recipeFileName);
        ConfigGenerator.saveJsonToFile(transformConfig, TRANSFORMS_PATH, transformFileName);
    }

    private static boolean configsExistForGun(String addonPrefix, String gunName) {
        String recipeFileName = addonPrefix + "_" + gunName + "_result.json";
        String transformFileName = addonPrefix + "_" + gunName + "_transform.json";
        String recipePath = Path.of(RECIPES_PATH, recipeFileName).toString();
        String transformPath = Path.of(TRANSFORMS_PATH, transformFileName).toString();
        return Files.exists(Path.of(recipePath, new String[0]), new LinkOption[0]) && Files.exists(Path.of(transformPath, new String[0]), new LinkOption[0]);
    }

    private static Map<String, Object> createGunRecipeData(String gunId) {
        HashMap<String, Object> configData = new HashMap<String, Object>();
        HashMap<String, Object> lootable = new HashMap<String, Object>();
        lootable.put("autoGenerateFromRecipe", true);
        lootable.put("recipeId", gunId);
        HashMap<String, Double> returnAmount = new HashMap<String, Double>();
        returnAmount.put("min", (Double)CommonConfig.DEFAULT_MIN_RETURN.get());
        returnAmount.put("max", (Double)CommonConfig.DEFAULT_MAX_RETURN.get());
        lootable.put("returnAmount", returnAmount);
        lootable.put("amountForMaxReturn", CommonConfig.AMOUNT_FOR_MAX_RETURN.get());
        configData.put("roundingType", CommonConfig.DEFAULT_ROUNDING_TYPE.get());
        configData.put("lootable", lootable);
        configData.put("requiredHits", CommonConfig.DEFAULT_REQUIRED_HITS.get());
        configData.put("explosionChance", CommonConfig.DEFAULT_EXPLOSION_CHANCE.get());
        configData.put("explosionPower", CommonConfig.DEFAULT_EXPLOSION_POWER.get());
        configData.put("requiredNbt", "{GunId:\"" + gunId + "\"}");
        if (((Boolean)CommonConfig.LOOTMULTIPLYER_BASED_ON_DURIBILITY.get()).booleanValue()) {
            configData.put("useDurabilityMultiplier", true);
        }
        return configData;
    }

    private static Map<String, Object> createGunTransformData(String gunId) {
        HashMap<String, Object> transformData = new HashMap<String, Object>();
        transformData.put("xLocation", CommonConfig.DEFAULT_X_LOCATION.get());
        transformData.put("yLocation", CommonConfig.DEFAULT_Y_LOCATION.get());
        transformData.put("zLocation", CommonConfig.DEFAULT_Z_LOCATION.get());
        transformData.put("layingRotation", CommonConfig.DEFAULT_LAYING_ROTATION.get());
        transformData.put("requiredNbt", "{GunId:\"" + gunId + "\"}");
        return transformData;
    }

    private static void generateRecipeConfig(ResourceLocation itemId) {
        try {
            HashMap config = new HashMap();
            ArrayList configList = new ArrayList();
            HashMap<String, Object> configData = new HashMap<String, Object>();
            HashMap<String, Object> lootable = new HashMap<String, Object>();
            if (((Boolean)CommonConfig.USE_RECIPE_BASED_LOOT.get()).booleanValue()) {
                lootable.put("autoGenerateFromRecipe", true);
                lootable.put("recipeId", itemId.toString());
                HashMap<String, Double> returnAmount = new HashMap<String, Double>();
                returnAmount.put("min", (Double)CommonConfig.DEFAULT_MIN_RETURN.get());
                returnAmount.put("max", (Double)CommonConfig.DEFAULT_MAX_RETURN.get());
                lootable.put("returnAmount", returnAmount);
                lootable.put("amountForMaxReturn", CommonConfig.AMOUNT_FOR_MAX_RETURN.get());
                configData.put("roundingType", CommonConfig.DEFAULT_ROUNDING_TYPE.get());
            } else if (((Boolean)CommonConfig.USE_LOOT_TABLES.get()).booleanValue()) {
                lootable.put("lootTable", CommonConfig.DEFAULT_LOOT_TABLE.get());
                lootable.put("autoGenerateFromRecipe", false);
            }
            configData.put("lootable", lootable);
            configData.put("requiredHits", CommonConfig.DEFAULT_REQUIRED_HITS.get());
            if (((Boolean)CommonConfig.USE_EXPLOSIONS.get()).booleanValue()) {
                configData.put("explosionChance", CommonConfig.DEFAULT_EXPLOSION_CHANCE.get());
                configData.put("explosionPower", CommonConfig.DEFAULT_EXPLOSION_POWER.get());
            }
            if (((Boolean)CommonConfig.LOOTMULTIPLYER_BASED_ON_DURIBILITY.get()).booleanValue()) {
                configData.put("useDurabilityMultiplier", true);
            }
            configList.add(configData);
            config.put(itemId.toString(), configList);
            String fileName = itemId.m_135827_() + "_" + itemId.m_135815_() + "_result.json";
            ItemScrapperLogger.debugLog("Saving recipe config to: generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper/recipes/" + fileName);
            ConfigGenerator.saveJsonToFile(config, RECIPES_PATH, fileName);
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("ERROR generating recipe config for " + itemId + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void generateTransformConfig(ResourceLocation itemId) {
        try {
            HashMap config = new HashMap();
            ArrayList configList = new ArrayList();
            HashMap<String, Object> transformData = new HashMap<String, Object>();
            transformData.put("xLocation", CommonConfig.DEFAULT_X_LOCATION.get());
            transformData.put("yLocation", CommonConfig.DEFAULT_Y_LOCATION.get());
            transformData.put("zLocation", CommonConfig.DEFAULT_Z_LOCATION.get());
            transformData.put("layingRotation", CommonConfig.DEFAULT_LAYING_ROTATION.get());
            configList.add(transformData);
            config.put(itemId.toString(), configList);
            String fileName = itemId.m_135827_() + "_" + itemId.m_135815_() + "_transform.json";
            ItemScrapperLogger.debugLog("Saving transform config to: generated_datapacks/item_scrapper_generated/data/item_scrapper/item_scrapper/transforms/" + fileName);
            ConfigGenerator.saveJsonToFile(config, TRANSFORMS_PATH, fileName);
        }
        catch (Exception e) {
            ItemScrapperLogger.errorLog("ERROR generating transform config for " + itemId + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void saveJsonToFile(Object content, String directory, String fileName) {
        try {
            File dir = new File(directory);
            if (!dir.exists()) {
                boolean created = dir.mkdirs();
                ItemScrapperLogger.debugLog("Created directory " + directory + ": " + created);
            }
            File file = new File(dir, fileName);
            ItemScrapperLogger.debugLog("Writing to file: " + file.getAbsolutePath());
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(content, (Appendable)writer);
                ItemScrapperLogger.debugLog("Successfully wrote config to: " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            ItemScrapperLogger.errorLog("ERROR saving JSON file: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

