/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.configs;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="item_scrapper", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue ENABLE_AUTO_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_TAGS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> INDIVIDUAL_ITEMS;
    public static final ForgeConfigSpec.BooleanValue USE_NEW_TACZ_FORMAT;
    public static final ForgeConfigSpec.BooleanValue USE_RECIPE_BASED_LOOT;
    public static final ForgeConfigSpec.BooleanValue USE_LOOT_TABLES;
    public static final ForgeConfigSpec.BooleanValue USE_EXPLOSIONS;
    public static final ForgeConfigSpec.BooleanValue LOOTMULTIPLYER_BASED_ON_DURIBILITY;
    public static final ForgeConfigSpec.BooleanValue GENERATE_TRANSFORMS;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_MIN_RETURN;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_MAX_RETURN;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_REQUIRED_HITS;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_EXPLOSION_POWER;
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_LOOT_TABLE;
    public static final ForgeConfigSpec.IntValue AMOUNT_FOR_MAX_RETURN;
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_ROUNDING_TYPE;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_X_LOCATION;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_Y_LOCATION;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_Z_LOCATION;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_LAYING_ROTATION;
    public static final ForgeConfigSpec SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC);
    }

    static {
        BUILDER.comment("Common configuration settings");
        BUILDER.push("auto_generation");
        ENABLE_AUTO_GENERATION = BUILDER.comment("Enable automatic generation of configs").define("enableAutoGeneration", true);
        USE_NEW_TACZ_FORMAT = BUILDER.comment("Use new TACZ format (true) or old format (false)").define("useNewTaczFormat", true);
        BUILDER.push("tags");
        ITEM_TAGS = BUILDER.comment("List of item tags to generate configs for").defineList("itemTags", Arrays.asList("forge:armors"), entry -> entry instanceof String);
        INDIVIDUAL_ITEMS = BUILDER.comment("List of individual items to generate configs for (e.g. 'minecraft:diamond_sword', 'modid:item_name')").defineList("individualItems", Arrays.asList("minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots", "minecraft:chainmail_helmet", "minecraft:chainmail_chestplate", "minecraft:chainmail_leggings", "minecraft:chainmail_boots", "minecraft:iron_helmet", "minecraft:iron_chestplate", "minecraft:iron_leggings", "minecraft:iron_boots", "minecraft:golden_helmet", "minecraft:golden_chestplate", "minecraft:golden_leggings", "minecraft:golden_boots", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots", "minecraft:turtle_helmet", "minecraft:trident"), entry -> entry instanceof String);
        BUILDER.pop();
        BUILDER.push("feature_toggles");
        USE_RECIPE_BASED_LOOT = BUILDER.comment("Generate recipe-based loot configs").define("useRecipeBasedLoot", true);
        USE_LOOT_TABLES = BUILDER.comment("Generate loot table-based configs").define("useLootTables", false);
        USE_EXPLOSIONS = BUILDER.comment("Include explosion chances in generated configs").define("useExplosions", true);
        GENERATE_TRANSFORMS = BUILDER.comment("Generate transform configs").define("generateTransforms", true);
        LOOTMULTIPLYER_BASED_ON_DURIBILITY = BUILDER.comment("Loot multiplyer based on the items duribility").define("lootMultiplyerBasedOnDuribility", false);
        BUILDER.pop();
        BUILDER.push("scrapper_defaults");
        DEFAULT_MIN_RETURN = BUILDER.comment("Default minimum return percentage").defineInRange("defaultMinReturn", 30.0, 0.0, 10000.0);
        DEFAULT_MAX_RETURN = BUILDER.comment("Default maximum return percentage").defineInRange("defaultMaxReturn", 70.0, 0.0, 10000.0);
        DEFAULT_REQUIRED_HITS = BUILDER.comment("Default required hits").defineInRange("defaultRequiredHits", 3.0, 0.1, 100.0);
        DEFAULT_EXPLOSION_CHANCE = BUILDER.comment("Default explosion chance").defineInRange("defaultExplosionChance", 0.0, 0.0, 100.0);
        DEFAULT_EXPLOSION_POWER = BUILDER.comment("Default explosion power").defineInRange("defaultExplosionPower", 0.0, 0.0, 100.0);
        AMOUNT_FOR_MAX_RETURN = BUILDER.comment("Amount For Max Return").defineInRange("amountForMaxReturn", 1, 1, 64);
        DEFAULT_LOOT_TABLE = BUILDER.comment("Default loot table path").define("defaultLootTable", (Object)"minecraft:chests/end_city_treasure");
        DEFAULT_ROUNDING_TYPE = BUILDER.comment("Default rounding type (STANDARD, FLOOR, CEILING)").define("defaultRoundingType", (Object)"STANDARD");
        BUILDER.pop();
        BUILDER.push("transform_defaults");
        DEFAULT_X_LOCATION = BUILDER.comment("Default X location offset").defineInRange("defaultXLocation", 0.0, -10.0, 10.0);
        DEFAULT_Y_LOCATION = BUILDER.comment("Default Y location offset").defineInRange("defaultYLocation", 0.0, -10.0, 10.0);
        DEFAULT_Z_LOCATION = BUILDER.comment("Default Z location offset").defineInRange("defaultZLocation", 0.0, -10.0, 10.0);
        DEFAULT_LAYING_ROTATION = BUILDER.comment("Default laying rotation offset").defineInRange("defaultLayingRotation", 0.0, -360.0, 360.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

