/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.configs;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue MAX_INPUT_ITEMS_RENDERED;
    public static final ForgeConfigSpec.IntValue MAX_OUTPUT_ITEMS_RENDERED;
    public static final ForgeConfigSpec.BooleanValue SHOW_SCRAPPABLE_INDICATOR;
    public static final ForgeConfigSpec.BooleanValue SHOW_REQUIRED_HITS;
    public static final ForgeConfigSpec.BooleanValue SHOW_RETURN_AMOUNT;
    public static final ForgeConfigSpec.BooleanValue SHOW_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.BooleanValue SHOW_DURABILITY_INFO;

    static {
        BUILDER.comment("Item Scrapper Rendering Configuration").push("rendering");
        MAX_INPUT_ITEMS_RENDERED = BUILDER.comment(new String[]{"Maximum number of items to render for the input item (visual only)", "This does not affect the actual capacity of the input slot, only how many items are shown"}).defineInRange("maxInputItemsRendered", 64, 1, 64);
        MAX_OUTPUT_ITEMS_RENDERED = BUILDER.comment(new String[]{"Maximum number of items to render for each output slot (visual only)", "This does not affect the actual output capacity, only how many items are shown"}).defineInRange("maxOutputItemsRendered", 64, 1, 64);
        BUILDER.pop();
        BUILDER.comment("Item Scrapper Tooltip Configuration").push("tooltips");
        SHOW_SCRAPPABLE_INDICATOR = BUILDER.comment("Show the scrappable indicator on items").define("showScrappableIndicator", true);
        SHOW_REQUIRED_HITS = BUILDER.comment("Show the required hits to scrap an item").define("showRequiredHits", false);
        SHOW_RETURN_AMOUNT = BUILDER.comment("Show the return amount percentage range").define("showReturnAmount", true);
        SHOW_EXPLOSION_CHANCE = BUILDER.comment("Show explosion chance on items that can explode").define("showExplosionChance", false);
        SHOW_DURABILITY_INFO = BUILDER.comment("Show durability multiplier information").define("showDurabilityInfo", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

