/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.command;

import com.keerdm.item_scrapper.configs.json.Scrapper_conversionsConfig;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.keerdm.item_scrapper.util.ItemScrapperLogger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class DebugConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debugscrapper").requires(source -> source.m_6761_(2))).executes(context -> {
            Map<String, List<Scrapper_conversionsConfig.ScrapConfig>> allConfigs = ScrapperDataManager.getAllConfigs();
            ItemScrapperLogger.debugLog("Command: Debug check - " + allConfigs.size() + " configs loaded");
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Total configs loaded: " + allConfigs.size())), false);
            int count = 0;
            for (String itemId : allConfigs.keySet()) {
                if (count < 5) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  - " + itemId)), false);
                }
                ++count;
            }
            if (count > 5) {
                int remaining = count - 5;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  ... and " + remaining + " more")), false);
            }
            return 1;
        })).then(Commands.m_82127_((String)"held").executes(context -> {
            Entity patt2069$temp = ((CommandSourceStack)context.getSource()).m_81373_();
            if (patt2069$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt2069$temp;
                ItemStack held = player.m_21205_();
                if (!held.m_41619_()) {
                    String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)held.m_41720_()).toString();
                    boolean hasConfig = ScrapperDataManager.getConfigForItem(itemId, held.m_41783_()) != null;
                    ItemScrapperLogger.debugLog("Command: Checking held item " + itemId + " - has config: " + hasConfig);
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Held: " + itemId + " | Has config: " + hasConfig)), false);
                } else {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No item in hand"), false);
                }
            }
            return 1;
        })));
    }
}

