/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.item_scrapper.client;

import com.keerdm.item_scrapper.blocks.ScrapperBlock;
import com.keerdm.item_scrapper.client.KeyBindings;
import com.keerdm.item_scrapper.data.ScrapperDataManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="item_scrapper")
public class ScrapperOverlayRenderer {
    private static final int TEXT_COLOR = -256;

    private static String getPromptText() {
        String keyName = KeyBindings.PLACE_ITEM_KEY.getKey().m_84875_().getString();
        return "Press [" + keyName + "] to place item";
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        String itemId;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91080_ != null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        if (!(minecraft.f_91073_.m_8055_(blockHit.m_82425_()).m_60734_() instanceof ScrapperBlock)) {
            return;
        }
        ItemStack heldItem = minecraft.f_91074_.m_21205_();
        if (!heldItem.m_41619_() && ScrapperDataManager.getConfigForItem(itemId = BuiltInRegistries.f_257033_.m_7981_((Object)heldItem.m_41720_()).toString(), heldItem.m_41783_()) != null) {
            GuiGraphics graphics = event.getGuiGraphics();
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            String promptText = ScrapperOverlayRenderer.getPromptText();
            int textWidth = minecraft.f_91062_.m_92895_(promptText);
            int x = (screenWidth - textWidth) / 2;
            int y = screenHeight / 2 - 20;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.m_280056_(minecraft.f_91062_, promptText, x, y, -256, true);
            RenderSystem.disableBlend();
        }
    }
}

